/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.text.ParseException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.LongPollingTransport;

public class JSONPTransport
extends LongPollingTransport {
    public static final String PREFIX = "long-polling.jsonp";
    public static final String NAME = "callback-polling";
    public static final String MIME_TYPE_OPTION = "mimeType";
    public static final String CALLBACK_PARAMETER_OPTION = "callbackParameter";
    private String _mimeType = "text/javascript;charset=UTF-8";
    private String _callbackParam = "jsonp";

    public JSONPTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    protected boolean isAlwaysFlushingAfterHandle() {
        return true;
    }

    protected void init() {
        super.init();
        this._callbackParam = this.getOption(CALLBACK_PARAMETER_OPTION, this._callbackParam);
        this._mimeType = this.getOption(MIME_TYPE_OPTION, this._mimeType);
        this.setMetaConnectDeliveryOnly(true);
    }

    public boolean accept(HttpServletRequest request) {
        return "GET".equals(request.getMethod()) && request.getParameter(this.getCallbackParameter()) != null;
    }

    protected ServerMessage.Mutable[] parseMessages(HttpServletRequest request) throws IOException, ParseException {
        return super.parseMessages(request.getParameterValues("message"));
    }

    public String getCallbackParameter() {
        return this._callbackParam;
    }

    protected ServletOutputStream beginWrite(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session) throws IOException {
        response.setContentType(this._mimeType);
        String callback = request.getParameter(this._callbackParam);
        ServletOutputStream output = response.getOutputStream();
        output.print(callback);
        output.print("([");
        return output;
    }

    protected void endWrite(ServletOutputStream output, ServerSessionImpl session) throws IOException {
        output.print("])");
        output.close();
    }
}

