/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.AttributesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelImpl
implements ServerChannel {
    private static final Logger _logger = LoggerFactory.getLogger(ServerChannel.class);
    private final BayeuxServerImpl _bayeux;
    private final ChannelId _id;
    private final AttributesMap _attributes = new AttributesMap();
    private final Set<ServerSession> _subscribers = new CopyOnWriteArraySet<ServerSession>();
    private final List<ConfigurableServerChannel.ServerChannelListener> _listeners = new CopyOnWriteArrayList<ConfigurableServerChannel.ServerChannelListener>();
    private final List<Authorizer> _authorizers = new CopyOnWriteArrayList<Authorizer>();
    private final CountDownLatch _initialized = new CountDownLatch(1);
    private final AtomicInteger _sweeperPasses = new AtomicInteger();
    private boolean _lazy;
    private long _lazyTimeout = -1L;
    private boolean _persistent;

    protected ServerChannelImpl(BayeuxServerImpl bayeux, ChannelId id) {
        this._bayeux = bayeux;
        this._id = id;
        this.setPersistent(!this.isBroadcast());
    }

    void waitForInitialized() {
        try {
            if (!this._initialized.await(5L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Not Initialized: " + this);
            }
        }
        catch (InterruptedException x) {
            throw new IllegalStateException("Initialization interrupted: " + this, x);
        }
    }

    void initialized() {
        this.resetSweeperPasses();
        this._initialized.countDown();
    }

    void resetSweeperPasses() {
        this._sweeperPasses.set(0);
    }

    public boolean subscribe(ServerSession session) {
        if (!session.isHandshook()) {
            return false;
        }
        if (this.isService()) {
            return true;
        }
        if (this.isMeta()) {
            return false;
        }
        return this.subscribe((ServerSessionImpl)session);
    }

    private boolean subscribe(ServerSessionImpl session) {
        this.resetSweeperPasses();
        if (this._subscribers.add(session)) {
            session.subscribedTo(this);
            for (ConfigurableServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                this.notifySubscribed((ServerChannel.SubscriptionListener)serverChannelListener, (ServerSession)session, (ServerChannel)this);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                this.notifySubscribed((BayeuxServer.SubscriptionListener)bayeuxServerListener, (ServerSession)session, (ServerChannel)this);
            }
        }
        return true;
    }

    private void notifySubscribed(ServerChannel.SubscriptionListener listener, ServerSession session, ServerChannel channel) {
        try {
            listener.subscribed(session, channel);
        }
        catch (Exception x) {
            _logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    private void notifySubscribed(BayeuxServer.SubscriptionListener listener, ServerSession session, ServerChannel channel) {
        try {
            listener.subscribed(session, channel);
        }
        catch (Exception x) {
            _logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    public boolean unsubscribe(ServerSession session) {
        if (this.isService()) {
            return true;
        }
        if (this.isMeta()) {
            return false;
        }
        return this.unsubscribe((ServerSessionImpl)session);
    }

    private boolean unsubscribe(ServerSessionImpl session) {
        if (this._subscribers.remove(session)) {
            session.unsubscribedFrom(this);
            for (ConfigurableServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                this.notifyUnsubscribed((ServerChannel.SubscriptionListener)serverChannelListener, (ServerSession)session, (ServerChannel)this);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                this.notifyUnsubscribed((BayeuxServer.SubscriptionListener)bayeuxServerListener, (ServerSession)session, (ServerChannel)this);
            }
        }
        return true;
    }

    private void notifyUnsubscribed(BayeuxServer.SubscriptionListener listener, ServerSession session, ServerChannel channel) {
        try {
            listener.unsubscribed(session, channel);
        }
        catch (Exception x) {
            _logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    private void notifyUnsubscribed(ServerChannel.SubscriptionListener listener, ServerSession session, ServerChannel channel) {
        try {
            listener.unsubscribed(session, channel);
        }
        catch (Exception x) {
            _logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    public Set<ServerSession> getSubscribers() {
        return Collections.unmodifiableSet(this.subscribers());
    }

    public Set<ServerSession> subscribers() {
        return this._subscribers;
    }

    public boolean isBroadcast() {
        return !this.isMeta() && !this.isService();
    }

    public boolean isDeepWild() {
        return this._id.isDeepWild();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public boolean isWild() {
        return this._id.isWild();
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
        if (!lazy) {
            this._lazyTimeout = -1L;
        }
    }

    public long getLazyTimeout() {
        return this._lazyTimeout;
    }

    public void setLazyTimeout(long lazyTimeout) {
        this._lazyTimeout = lazyTimeout;
        this.setLazy(lazyTimeout > 0L);
    }

    public void setPersistent(boolean persistent) {
        this.resetSweeperPasses();
        this._persistent = persistent;
    }

    public void addListener(ConfigurableServerChannel.ServerChannelListener listener) {
        this.resetSweeperPasses();
        this._listeners.add(listener);
    }

    public void removeListener(ConfigurableServerChannel.ServerChannelListener listener) {
        this._listeners.remove(listener);
    }

    public List<ConfigurableServerChannel.ServerChannelListener> getListeners() {
        return Collections.unmodifiableList(this.listeners());
    }

    protected List<ConfigurableServerChannel.ServerChannelListener> listeners() {
        return this._listeners;
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isMeta() {
        return this._id.isMeta();
    }

    public boolean isService() {
        return this._id.isService();
    }

    public void publish(Session from, ServerMessage.Mutable mutable) {
        if (this.isWild()) {
            throw new IllegalStateException("Wild publish");
        }
        ServerSessionImpl session = from instanceof ServerSessionImpl ? (ServerSessionImpl)from : (from instanceof LocalSession ? (ServerSessionImpl)((LocalSession)from).getServerSession() : null);
        mutable.setClientId(null);
        mutable.setId(null);
        if (this._bayeux.extendSend(session, null, mutable)) {
            this._bayeux.doPublish(session, this, mutable);
        }
    }

    public void publish(Session from, Object data) {
        ServerMessage.Mutable mutable = this._bayeux.newMessage();
        mutable.setChannel(this.getId());
        if (from != null) {
            mutable.setClientId(from.getId());
        }
        mutable.setData(data);
        this.publish(from, mutable);
    }

    protected void sweep() {
        this.waitForInitialized();
        for (ServerSession session : this._subscribers) {
            if (session.isHandshook()) continue;
            this.unsubscribe((ServerSessionImpl)session);
        }
        if (this.isPersistent()) {
            return;
        }
        if (this._subscribers.size() > 0) {
            return;
        }
        if (this._authorizers.size() > 0) {
            return;
        }
        for (ConfigurableServerChannel.ServerChannelListener listener : this._listeners) {
            if (listener instanceof ConfigurableServerChannel.ServerChannelListener.Weak) continue;
            return;
        }
        if (this._sweeperPasses.incrementAndGet() < 3) {
            return;
        }
        this.remove();
    }

    public void remove() {
        if (this._bayeux.removeServerChannel(this)) {
            for (ServerSession subscriber : this._subscribers) {
                ((ServerSessionImpl)subscriber).unsubscribedFrom(this);
            }
            this._subscribers.clear();
        }
        this._listeners.clear();
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append(this.isLazy() ? " lazy" : "");
        b.append('\n');
        int leaves = this._subscribers.size() + this._listeners.size() + this._authorizers.size();
        int i = 0;
        for (ServerSession serverSession : this._subscribers) {
            b.append(indent);
            b.append(" +-");
            ((ServerSessionImpl)serverSession).dump(b, indent + (++i == leaves ? "   " : " | "));
        }
        for (ConfigurableServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(serverChannelListener);
            b.append('\n');
        }
        for (Authorizer authorizer : this._authorizers) {
            b.append(indent);
            b.append(" +-");
            b.append(authorizer);
            b.append('\n');
        }
    }

    public void addAuthorizer(Authorizer authorizer) {
        this._authorizers.add(authorizer);
    }

    public void removeAuthorizer(Authorizer authorizer) {
        this._authorizers.remove(authorizer);
    }

    public List<Authorizer> getAuthorizers() {
        return Collections.unmodifiableList(this.authorizers());
    }

    protected List<Authorizer> authorizers() {
        return this._authorizers;
    }

    public String toString() {
        return this._id.toString();
    }
}

