/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.thread.Scheduler;

public class AsyncJSONTransport
extends HttpTransport {
    private static final String PREFIX = "long-polling.json";
    private static final String NAME = "long-polling";

    public AsyncJSONTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        request.setCharacterEncoding(encoding);
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(0L);
        Charset charset = Charset.forName(encoding);
        AbstractReader reader = "UTF-8".equals(charset.name()) ? new UTF8Reader(asyncContext) : new CharsetReader(asyncContext, charset);
        ServletInputStream input = request.getInputStream();
        input.setReadListener((ReadListener)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessages(AsyncContext asyncContext, ServerMessage.Mutable[] messages) throws IOException {
        boolean autoBatch = this.isAutoBatch();
        ServerSessionImpl session = null;
        boolean batch = false;
        boolean metaConnect = false;
        boolean suspended = false;
        boolean disconnected = false;
        try {
            block11: for (int i = 0; i < messages.length; ++i) {
                ServerMessage.Mutable message = messages[i];
                this._logger.debug("Processing message {}", (Object)message);
                if (session == null && !disconnected) {
                    session = (ServerSessionImpl)this.getBayeux().getSession(message.getClientId());
                }
                if (session != null) {
                    boolean bl = disconnected = !session.isHandshook();
                    if (disconnected) {
                        if (batch) {
                            batch = false;
                            session.endBatch();
                        }
                        session = null;
                    } else if (autoBatch && !batch) {
                        batch = true;
                        session.startBatch();
                    }
                }
                switch (message.getChannel()) {
                    case "/meta/handshake": {
                        ServerMessage.Mutable reply = messages[i] = this.processMetaHandshake(asyncContext, session, message);
                        if (reply == null) continue block11;
                        session = (ServerSessionImpl)this.getBayeux().getSession(reply.getClientId());
                        continue block11;
                    }
                    case "/meta/connect": {
                        ServerMessage.Mutable reply = messages[i] = this.processMetaConnect(asyncContext, session, message);
                        metaConnect = true;
                        if (reply != null) continue block11;
                        suspended = messages.length == 1;
                        continue block11;
                    }
                    default: {
                        ServerMessage.Mutable reply = this.bayeuxServerHandle(session, message);
                        messages[i] = this.processReply(session, reply);
                        continue block11;
                    }
                }
            }
            if (!suspended) {
                this.flush(asyncContext, session, metaConnect, messages);
            }
        }
        finally {
            if (batch) {
                session.endBatch();
            }
        }
    }

    protected ServerMessage.Mutable processMetaHandshake(AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable message) {
        HttpServletRequest request;
        String browserId;
        ServerMessage.Mutable reply = this.bayeuxServerHandle(session, message);
        if (reply != null && (session = (ServerSessionImpl)this.getBayeux().getSession(reply.getClientId())) != null && (browserId = this.findBrowserId(request = (HttpServletRequest)asyncContext.getRequest())) == null) {
            this.setBrowserId(request, (HttpServletResponse)asyncContext.getResponse());
        }
        return this.processReply(session, reply);
    }

    protected ServerMessage.Mutable processMetaConnect(AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable message) {
        if (session != null) {
            session.setScheduler(null);
        }
        boolean wasConnected = session != null && session.isConnected();
        ServerMessage.Mutable reply = this.bayeuxServerHandle(session, message);
        if (reply != null && session != null) {
            if (!session.hasNonLazyMessages() && reply.isSuccessful()) {
                boolean allowSuspendConnect;
                HttpServletRequest request = (HttpServletRequest)asyncContext.getRequest();
                String browserId = this.findBrowserId(request);
                if (browserId != null) {
                    allowSuspendConnect = this.incBrowserId(browserId, session);
                } else {
                    boolean bl = allowSuspendConnect = this.isAllowMultiSessionsNoBrowser() || request.getHeader("Origin") != null;
                }
                if (allowSuspendConnect) {
                    long timeout = session.calculateTimeout(this.getTimeout());
                    if (timeout > 0L && wasConnected && session.isConnected()) {
                        LongPollingScheduler scheduler = new LongPollingScheduler(asyncContext, session, reply, browserId);
                        scheduler.scheduleTimeout(timeout);
                        this.metaConnectSuspended(asyncContext, session);
                        session.setScheduler(scheduler);
                        reply = null;
                    } else {
                        this.decBrowserId(browserId, session);
                    }
                } else {
                    long multiSessionInterval;
                    Map advice = reply.getAdvice(true);
                    if (browserId != null) {
                        advice.put("multiple-clients", true);
                    }
                    if ((multiSessionInterval = this.getMultiSessionInterval()) > 0L) {
                        advice.put("reconnect", "retry");
                        advice.put("interval", multiSessionInterval);
                    } else {
                        advice.put("reconnect", "none");
                        reply.setSuccessful(false);
                    }
                    session.reAdvise();
                }
            }
            if (reply != null && session.isDisconnected()) {
                reply.getAdvice(true).put("reconnect", "none");
            }
        }
        return this.processReply(session, reply);
    }

    protected ServerMessage.Mutable processReply(ServerSessionImpl session, ServerMessage.Mutable reply) {
        if (reply != null && (reply = this.getBayeux().extendReply(session, session, reply)) != null) {
            this.getBayeux().freeze(reply);
        }
        return reply;
    }

    protected void flush(AsyncContext asyncContext, ServerSessionImpl session, boolean startInterval, ServerMessage.Mutable ... replies) {
        try {
            List<ServerMessage> messages = Collections.emptyList();
            if (session != null && (startInterval || !this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly())) {
                messages = session.takeQueue();
            }
            ServletResponse response = asyncContext.getResponse();
            response.setContentType("application/json;charset=UTF-8");
            ServletOutputStream output = response.getOutputStream();
            output.setWriteListener((WriteListener)new Writer(asyncContext, session, startInterval, messages, replies));
        }
        catch (IOException x) {
            this.error(asyncContext, 500);
        }
    }

    private void error(AsyncContext asyncContext, int responseCode) {
        try {
            HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
            if (!response.isCommitted()) {
                response.sendError(responseCode);
            }
        }
        catch (IOException x) {
            this._logger.trace("Could not send " + responseCode + " response", (Throwable)x);
        }
        try {
            asyncContext.complete();
        }
        catch (Exception x) {
            this._logger.trace("Could not complete " + responseCode + " response", (Throwable)x);
        }
    }

    private class LongPollingScheduler
    implements Runnable,
    AbstractServerTransport.OneTimeScheduler,
    AsyncListener {
        private final AsyncContext asyncContext;
        private final ServerSessionImpl session;
        private final ServerMessage.Mutable reply;
        private final String browserId;
        private volatile Scheduler.Task task;

        private LongPollingScheduler(AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, String browserId) {
            this.asyncContext = asyncContext;
            this.session = session;
            this.reply = reply;
            this.browserId = browserId;
            asyncContext.addListener((AsyncListener)this);
        }

        @Override
        public void schedule() {
            if (this.cancelTimeout()) {
                AsyncJSONTransport.this._logger.debug("Resuming /meta/connect after schedule");
                this.resume();
            }
        }

        @Override
        public void cancel() {
            if (this.cancelTimeout()) {
                AsyncJSONTransport.this._logger.debug("Duplicate /meta/connect, cancelling {}", (Object)this.reply);
                this.error();
            }
        }

        private void scheduleTimeout(long timeout) {
            this.task = AsyncJSONTransport.this.getBayeux().schedule(this, timeout);
        }

        private boolean cancelTimeout() {
            Scheduler.Task task = this.task;
            return task != null && task.cancel();
        }

        @Override
        public void run() {
            this.task = null;
            this.session.setScheduler(null);
            AsyncJSONTransport.this._logger.debug("Resuming /meta/connect after timeout");
            this.resume();
        }

        private void resume() {
            AsyncJSONTransport.this.metaConnectResumed(this.asyncContext, this.session);
            Map<String, Object> advice = this.session.takeAdvice(AsyncJSONTransport.this);
            if (advice != null) {
                this.reply.put((Object)"advice", advice);
            }
            if (this.session.isDisconnected()) {
                this.reply.getAdvice(true).put("reconnect", "none");
            }
            AsyncJSONTransport.this.decBrowserId(this.browserId, this.session);
            AsyncJSONTransport.this.flush(this.asyncContext, this.session, true, AsyncJSONTransport.this.processReply(this.session, this.reply));
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent asyncEvent) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
            this.error();
        }

        private void error() {
            AsyncJSONTransport.this.decBrowserId(this.browserId, this.session);
            AsyncJSONTransport.this.error(this.asyncContext, 500);
        }
    }

    protected class Writer
    implements WriteListener {
        private final StringBuilder buffer = new StringBuilder(512);
        private final AsyncContext asyncContext;
        private final ServerSessionImpl session;
        private final boolean startInterval;
        private final List<ServerMessage> messages;
        private final ServerMessage.Mutable[] replies;
        private int messageIndex = -1;
        private int replyIndex;

        public Writer(AsyncContext asyncContext, ServerSessionImpl session, boolean startInterval, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
            this.asyncContext = asyncContext;
            this.session = session;
            this.startInterval = startInterval;
            this.messages = messages;
            this.replies = replies;
        }

        public void onWritePossible() throws IOException {
            boolean needsComma;
            ServletOutputStream output = this.asyncContext.getResponse().getOutputStream();
            if (this.messageIndex < 0) {
                this.messageIndex = 0;
                this.buffer.append("[");
            }
            AsyncJSONTransport.this._logger.debug("Messages to write for session {}: {}", (Object)this.session, (Object)this.messages.size());
            while (this.messageIndex < this.messages.size()) {
                if (this.messageIndex > 0) {
                    this.buffer.append(",");
                }
                this.buffer.append(this.messages.get(this.messageIndex++).getJSON());
                output.write(this.buffer.toString().getBytes("UTF-8"));
                this.buffer.setLength(0);
                if (output.isReady()) continue;
                return;
            }
            if (this.replyIndex == 0 && this.startInterval && this.session != null && this.session.isConnected()) {
                this.session.startIntervalTimeout(AsyncJSONTransport.this.getInterval());
            }
            AsyncJSONTransport.this._logger.debug("Replies to write for session {}: {}", (Object)this.session, (Object)this.replies.length);
            boolean bl = needsComma = this.messageIndex > 0;
            while (this.replyIndex < this.replies.length) {
                ServerMessage.Mutable reply;
                if ((reply = this.replies[this.replyIndex++]) == null) continue;
                if (needsComma) {
                    this.buffer.append(",");
                }
                needsComma = true;
                this.buffer.append(reply.getJSON());
                if (this.replyIndex == this.replies.length) {
                    this.buffer.append("]");
                }
                output.write(this.buffer.toString().getBytes("UTF-8"));
                this.buffer.setLength(0);
                if (output.isReady()) continue;
                return;
            }
            this.asyncContext.complete();
        }

        public void onError(Throwable throwable) {
            AsyncJSONTransport.this.error(this.asyncContext, 500);
        }
    }

    protected class CharsetReader
    extends AbstractReader {
        private byte[] content;
        private final Charset charset;
        private int count;

        public CharsetReader(AsyncContext asyncContext, Charset charset) {
            super(asyncContext);
            this.content = new byte[512];
            this.charset = charset;
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            int size;
            int newSize = size = this.content.length;
            while (newSize - this.count < length) {
                newSize <<= 1;
            }
            if (newSize < 0) {
                throw new IllegalArgumentException("Message too large");
            }
            if (newSize != size) {
                byte[] newContent = new byte[newSize];
                System.arraycopy(this.content, 0, newContent, 0, this.count);
                this.content = newContent;
            }
            System.arraycopy(buffer, offset, this.content, this.count, length);
            this.count += length;
        }

        @Override
        protected String finish() {
            return new String(this.content, 0, this.count, this.charset);
        }
    }

    protected class UTF8Reader
    extends AbstractReader {
        private final Utf8StringBuilder content;

        protected UTF8Reader(AsyncContext asyncContext) {
            super(asyncContext);
            this.content = new Utf8StringBuilder(512);
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            this.content.append(buffer, offset, length);
        }

        @Override
        protected String finish() {
            return this.content.toString();
        }
    }

    protected abstract class AbstractReader
    implements ReadListener {
        protected static final int CAPACITY = 512;
        private final byte[] buffer = new byte[512];
        protected final AsyncContext asyncContext;

        protected AbstractReader(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        public void onDataAvailable() throws IOException {
            ServletInputStream input = this.asyncContext.getRequest().getInputStream();
            AsyncJSONTransport.this._logger.debug("Asynchronous read start from {}", (Object)input);
            while (input.isReady()) {
                int read = input.read(this.buffer);
                AsyncJSONTransport.this._logger.debug("Asynchronous read {} bytes from {}", (Object)read, (Object)input);
                this.append(this.buffer, 0, read);
            }
            if (!input.isFinished()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read pending from {}", (Object)input);
            }
        }

        protected abstract void append(byte[] var1, int var2, int var3);

        public void onAllDataRead() throws IOException {
            ServletInputStream input = this.asyncContext.getRequest().getInputStream();
            String json = this.finish();
            AsyncJSONTransport.this._logger.debug("Asynchronous read end from {}: {}", (Object)input, (Object)json);
            this.process(json);
        }

        protected abstract String finish();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(String json) throws IOException {
            AsyncJSONTransport.this.getBayeux().setCurrentTransport(AsyncJSONTransport.this);
            AsyncJSONTransport.this.setCurrentRequest((HttpServletRequest)this.asyncContext.getRequest());
            try {
                ServerMessage.Mutable[] messages = AsyncJSONTransport.this.parseMessages(json);
                AsyncJSONTransport.this._logger.debug("Parsed {} messages", (Object)messages.length);
                AsyncJSONTransport.this.processMessages(this.asyncContext, messages);
            }
            catch (ParseException x) {
                AsyncJSONTransport.this.handleJSONParseException((HttpServletRequest)this.asyncContext.getRequest(), (HttpServletResponse)this.asyncContext.getResponse(), json, x);
                this.asyncContext.complete();
            }
            finally {
                AsyncJSONTransport.this.setCurrentRequest(null);
                AsyncJSONTransport.this.getBayeux().setCurrentTransport(null);
            }
        }

        public void onError(Throwable throwable) {
            AsyncJSONTransport.this.error(this.asyncContext, 500);
        }
    }
}

