/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpTransport
extends AbstractServerTransport {
    public static final String PREFIX = "long-polling";
    public static final String JSON_DEBUG_OPTION = "jsonDebug";
    public static final String MESSAGE_PARAM = "message";
    public static final String BROWSER_COOKIE_NAME_OPTION = "browserCookieName";
    public static final String BROWSER_COOKIE_DOMAIN_OPTION = "browserCookieDomain";
    public static final String BROWSER_COOKIE_PATH_OPTION = "browserCookiePath";
    public static final String MAX_SESSIONS_PER_BROWSER_OPTION = "maxSessionsPerBrowser";
    public static final String MULTI_SESSION_INTERVAL_OPTION = "multiSessionInterval";
    public static final String AUTOBATCH_OPTION = "autoBatch";
    public static final String ALLOW_MULTI_SESSIONS_NO_BROWSER_OPTION = "allowMultiSessionsNoBrowser";
    protected final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ThreadLocal<HttpServletRequest> _currentRequest = new ThreadLocal();
    private final ConcurrentHashMap<String, AtomicInteger> _browserMap = new ConcurrentHashMap();
    private final Map<String, AtomicInteger> _browserSweep = new ConcurrentHashMap<String, AtomicInteger>();
    private String _browserCookieName;
    private String _browserCookieDomain;
    private String _browserCookiePath;
    private int _maxSessionsPerBrowser;
    private long _multiSessionInterval;
    private boolean _autoBatch;
    private boolean _allowMultiSessionsNoBrowser;
    private long _lastSweep;

    protected HttpTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    protected void init() {
        super.init();
        this._browserCookieName = this.getOption(BROWSER_COOKIE_NAME_OPTION, "BAYEUX_BROWSER");
        this._browserCookieDomain = this.getOption(BROWSER_COOKIE_DOMAIN_OPTION, null);
        this._browserCookiePath = this.getOption(BROWSER_COOKIE_PATH_OPTION, "/");
        this._maxSessionsPerBrowser = this.getOption(MAX_SESSIONS_PER_BROWSER_OPTION, 1);
        this._multiSessionInterval = this.getOption(MULTI_SESSION_INTERVAL_OPTION, 2000);
        this._autoBatch = this.getOption(AUTOBATCH_OPTION, true);
        this._allowMultiSessionsNoBrowser = this.getOption(ALLOW_MULTI_SESSIONS_NO_BROWSER_OPTION, false);
    }

    public abstract boolean accept(HttpServletRequest var1);

    public abstract void handle(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    protected long getMultiSessionInterval() {
        return this._multiSessionInterval;
    }

    protected boolean isAutoBatch() {
        return this._autoBatch;
    }

    protected boolean isAllowMultiSessionsNoBrowser() {
        return this._allowMultiSessionsNoBrowser;
    }

    public void setCurrentRequest(HttpServletRequest request) {
        this._currentRequest.set(request);
    }

    public HttpServletRequest getCurrentRequest() {
        return this._currentRequest.get();
    }

    public BayeuxContext getContext() {
        HttpServletRequest request = this.getCurrentRequest();
        if (request != null) {
            return new HttpContext(request);
        }
        return null;
    }

    protected String findBrowserId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserCookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected String setBrowserId(HttpServletRequest request, HttpServletResponse response) {
        String browserId = Long.toHexString(request.getRemotePort()) + Long.toString(this.getBayeux().randomLong(), 36) + Long.toString(System.currentTimeMillis(), 36) + Long.toString(request.getRemotePort(), 36);
        Cookie cookie = new Cookie(this._browserCookieName, browserId);
        if (this._browserCookieDomain != null) {
            cookie.setDomain(this._browserCookieDomain);
        }
        cookie.setPath(this._browserCookiePath);
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browserId;
    }

    protected boolean incBrowserId(String browserId, ServerSession session) {
        int sessions;
        AtomicInteger newCount;
        if (this._maxSessionsPerBrowser < 0) {
            return true;
        }
        if (this._maxSessionsPerBrowser == 0) {
            return false;
        }
        AtomicInteger count = this._browserMap.get(browserId);
        if (count == null && (count = this._browserMap.putIfAbsent(browserId, newCount = new AtomicInteger())) == null) {
            count = newCount;
        }
        if ((sessions = count.incrementAndGet()) == 1) {
            this._browserSweep.remove(browserId);
        }
        boolean result = true;
        if (sessions > this._maxSessionsPerBrowser) {
            sessions = count.decrementAndGet();
            result = false;
        }
        this._logger.debug("> client {} {} sessions from {}", new Object[]{browserId, sessions, session});
        return result;
    }

    protected void decBrowserId(String browserId, ServerSession session) {
        if (browserId == null) {
            return;
        }
        int sessions = -1;
        AtomicInteger count = this._browserMap.get(browserId);
        if (count != null) {
            sessions = count.decrementAndGet();
        }
        if (sessions == 0) {
            this._browserSweep.put(browserId, new AtomicInteger(0));
        }
        this._logger.debug("< client {} {} sessions for {}", new Object[]{browserId, sessions, session});
    }

    protected void handleJSONParseException(HttpServletRequest request, HttpServletResponse response, String json, Throwable exception) throws IOException {
        try {
            this._logger.warn("Could not parse JSON: " + json, exception);
            if (!response.isCommitted()) {
                response.sendError(400);
            }
        }
        catch (IOException x) {
            this._logger.trace("Could not send response error", (Throwable)x);
        }
    }

    protected ServerMessage.Mutable bayeuxServerHandle(ServerSessionImpl session, ServerMessage.Mutable message) {
        return this.getBayeux().handle(session, message);
    }

    protected void metaConnectSuspended(AsyncContext asyncContext, ServerSession session) {
    }

    protected void metaConnectResumed(AsyncContext asyncContext, ServerSession session) {
    }

    @Override
    protected void sweep() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._lastSweep;
        if (this._lastSweep > 0L && elapsed > 0L) {
            int maxSweeps = (int)(2L * this.getMaxInterval() / elapsed);
            for (Map.Entry<String, AtomicInteger> entry : this._browserSweep.entrySet()) {
                String key;
                AtomicInteger count = entry.getValue();
                if (count == null || count.incrementAndGet() <= maxSweeps || this._browserSweep.remove(key = entry.getKey()) != count || this._browserMap.get(key).get() != 0) continue;
                this._browserMap.remove(key);
                this._logger.debug("Swept browserId {}", (Object)key);
            }
        }
        this._lastSweep = now;
    }

    private static class HttpContext
    implements BayeuxContext {
        final HttpServletRequest _request;

        HttpContext(HttpServletRequest request) {
            this._request = request;
        }

        public Principal getUserPrincipal() {
            return this._request.getUserPrincipal();
        }

        public boolean isUserInRole(String role) {
            return this._request.isUserInRole(role);
        }

        public InetSocketAddress getRemoteAddress() {
            return new InetSocketAddress(this._request.getRemoteHost(), this._request.getRemotePort());
        }

        public InetSocketAddress getLocalAddress() {
            return new InetSocketAddress(this._request.getLocalName(), this._request.getLocalPort());
        }

        public String getHeader(String name) {
            return this._request.getHeader(name);
        }

        public List<String> getHeaderValues(String name) {
            return Collections.list(this._request.getHeaders(name));
        }

        public String getParameter(String name) {
            return this._request.getParameter(name);
        }

        public List<String> getParameterValues(String name) {
            return Arrays.asList(this._request.getParameterValues(name));
        }

        public String getCookie(String name) {
            Cookie[] cookies = this._request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!name.equals(c.getName())) continue;
                    return c.getValue();
                }
            }
            return null;
        }

        public String getHttpSessionId() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getId();
            }
            return null;
        }

        public Object getHttpSessionAttribute(String name) {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getAttribute(name);
            }
            return null;
        }

        public void setHttpSessionAttribute(String name, Object value) {
            HttpSession session = this._request.getSession(false);
            if (session == null) {
                throw new IllegalStateException("!session");
            }
            session.setAttribute(name, value);
        }

        public void invalidateHttpSession() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return this._request.getAttribute(name);
        }

        private ServletContext getServletContext() {
            HttpSession s = this._request.getSession(false);
            if (s != null) {
                return s.getServletContext();
            }
            s = this._request.getSession(true);
            ServletContext servletContext = s.getServletContext();
            s.invalidate();
            return servletContext;
        }

        public Object getContextAttribute(String name) {
            return this.getServletContext().getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this.getServletContext().getInitParameter(name);
        }

        public String getURL() {
            StringBuffer url = this._request.getRequestURL();
            String query = this._request.getQueryString();
            if (query != null) {
                url.append("?").append(query);
            }
            return url.toString();
        }
    }
}

