/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;

public abstract class LongPollingTransport
extends HttpTransport {
    protected LongPollingTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.getBayeux().setCurrentTransport(this);
        this.setCurrentRequest(request);
        try {
            this.process(request, response);
        }
        finally {
            this.setCurrentRequest(null);
            this.getBayeux().setCurrentTransport(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        scheduler = (LongPollScheduler)request.getAttribute("org.cometd.scheduler");
        if (scheduler == null) {
            batch = false;
            session = null;
            connect = false;
            try {
                messages = this.parseMessages(request);
                if (messages == null) {
                    return;
                }
                writer = null;
                for (ServerMessage.Mutable message : messages) {
                    connect = "/meta/connect".equals(message.getChannel());
                    client_id = message.getClientId();
                    if (session == null || client_id != null && !client_id.equals(session.getId())) {
                        session = (ServerSessionImpl)this.getBayeux().getSession(client_id);
                        if (this.isAutoBatch() && !batch && session != null && !connect && !message.isMeta()) {
                            batch = true;
                            session.startBatch();
                        }
                    } else if (!session.isHandshook()) {
                        batch = false;
                        session = null;
                    }
                    if (connect && session != null) {
                        session.setScheduler(null);
                    }
                    wasConnected = session != null && session.isConnected() != false;
                    reply = this.bayeuxServerHandle(session, message);
                    if (reply != null) {
                        if (session == null) {
                            session = (ServerSessionImpl)this.getBayeux().getSession(reply.getClientId());
                            if (session != null && (browserId = this.findBrowserId(request)) == null) {
                                this.setBrowserId(request, response);
                            }
                        } else if (connect) {
                            try {
                                if (session.hasNonLazyMessages() || !reply.isSuccessful()) ** GOTO lbl76
                                browserId = this.findBrowserId(request);
                                if (browserId != null) {
                                    allowSuspendConnect = this.incBrowserId(browserId, session);
                                } else {
                                    v0 = allowSuspendConnect = this.isAllowMultiSessionsNoBrowser() != false || request.getHeader("Origin") != null;
                                }
                                if (allowSuspendConnect) {
                                    timeout = session.calculateTimeout(this.getTimeout());
                                    if (timeout > 0L && wasConnected && session.isConnected()) {
                                        asyncContext = request.startAsync();
                                        asyncContext.setTimeout(timeout);
                                        scheduler = this.newLongPollScheduler(session, asyncContext, reply, browserId);
                                        request.setAttribute("org.cometd.scheduler", (Object)scheduler);
                                        session.setScheduler(scheduler);
                                        reply = null;
                                        this.metaConnectSuspended(asyncContext, session);
                                    }
                                    this.decBrowserId(browserId, session);
                                }
                                advice = reply.getAdvice(true);
                                if (browserId != null) {
                                    advice.put("multiple-clients", true);
                                }
                                if ((multiSessionInterval = this.getMultiSessionInterval()) > 0L) {
                                    advice.put("reconnect", "retry");
                                    advice.put("interval", multiSessionInterval);
                                } else {
                                    advice.put("reconnect", "none");
                                    reply.setSuccessful(false);
                                }
                                session.reAdvise();
                            }
                            finally {
                                if (reply != null) {
                                    writer = this.writeQueueForMetaConnect(request, response, session, writer);
                                }
                            }
                        } else if (!this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly()) {
                            writer = this.writeQueue(request, response, session, writer);
                        }
lbl76:
                        // 8 sources

                        if (reply != null) {
                            if (connect && session != null && session.isDisconnected()) {
                                reply.getAdvice(true).put("reconnect", "none");
                            }
                            if ((reply = this.getBayeux().extendReply(session, session, reply)) != null) {
                                this.getBayeux().freeze(reply);
                                writer = this.writeMessage(request, response, writer, session, (ServerMessage)reply);
                            }
                        }
                    }
                    message.setAssociated(null);
                }
                if (writer == null) ** GOTO lbl110
                this.finishWrite(writer, session);
            }
            catch (ParseException x) {
                this.handleJSONParseException(request, response, x.getMessage(), x.getCause());
            }
            finally {
                if (batch) {
                    if (!session.endBatch() && this.isAlwaysFlushingAfterHandle()) {
                        session.flush();
                    }
                } else if (session != null && !connect && this.isAlwaysFlushingAfterHandle()) {
                    session.flush();
                }
            }
        } else {
            session = scheduler.getSession();
            this.metaConnectResumed(request.getAsyncContext(), session);
            writer = this.writeQueueForMetaConnect(request, response, session, null);
            reply = scheduler.getReply();
            if (session.isDisconnected()) {
                reply.getAdvice(true).put("reconnect", "none");
            }
            if ((reply = this.getBayeux().extendReply(session, session, reply)) != null) {
                this.getBayeux().freeze(reply);
                writer = this.writeMessage(request, response, writer, session, (ServerMessage)reply);
            }
            this.finishWrite(writer, session);
        }
lbl110:
        // 4 sources

    }

    protected LongPollScheduler newLongPollScheduler(ServerSessionImpl session, AsyncContext asyncContext, ServerMessage.Mutable metaConnectReply, String browserId) {
        return new LongPollScheduler(session, asyncContext, metaConnectReply, browserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintWriter writeQueueForMetaConnect(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, PrintWriter writer) throws IOException {
        try {
            PrintWriter printWriter = this.writeQueue(request, response, session, writer);
            return printWriter;
        }
        finally {
            if (session.isConnected()) {
                session.startIntervalTimeout(this.getInterval());
            }
        }
    }

    private PrintWriter writeQueue(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, PrintWriter writer) throws IOException {
        List<ServerMessage> queue = session.takeQueue();
        for (ServerMessage m : queue) {
            writer = this.writeMessage(request, response, writer, session, m);
        }
        return writer;
    }

    protected ServerMessage.Mutable[] parseMessages(String[] requestParameters) throws IOException, ParseException {
        if (requestParameters == null || requestParameters.length == 0) {
            throw new IOException("Missing 'message' request parameter");
        }
        if (requestParameters.length == 1) {
            return this.parseMessages(requestParameters[0]);
        }
        ArrayList<ServerMessage.Mutable> messages = new ArrayList<ServerMessage.Mutable>();
        for (String batch : requestParameters) {
            if (batch == null) continue;
            messages.addAll(Arrays.asList(this.parseMessages(batch)));
        }
        return messages.toArray(new ServerMessage.Mutable[messages.size()]);
    }

    protected abstract ServerMessage.Mutable[] parseMessages(HttpServletRequest var1) throws IOException, ParseException;

    protected abstract boolean isAlwaysFlushingAfterHandle();

    protected abstract PrintWriter writeMessage(HttpServletRequest var1, HttpServletResponse var2, PrintWriter var3, ServerSessionImpl var4, ServerMessage var5) throws IOException;

    protected abstract void finishWrite(PrintWriter var1, ServerSessionImpl var2) throws IOException;

    protected class LongPollScheduler
    implements AbstractServerTransport.OneTimeScheduler,
    AsyncListener {
        private static final String ATTRIBUTE = "org.cometd.scheduler";
        private final ServerSessionImpl _session;
        private final AsyncContext _asyncContext;
        private final ServerMessage.Mutable _reply;
        private final String _browserId;
        private volatile boolean _expired;

        public LongPollScheduler(ServerSessionImpl session, AsyncContext asyncContext, ServerMessage.Mutable reply, String browserId) {
            this._session = session;
            this._asyncContext = asyncContext;
            this._asyncContext.addListener((AsyncListener)this);
            this._reply = reply;
            this._browserId = browserId;
        }

        @Override
        public void cancel() {
            if (this._asyncContext.getRequest().isAsyncStarted() && !this._expired) {
                try {
                    LongPollingTransport.this._logger.debug("Duplicate /meta/connect, canceling {}", (Object)this._reply);
                    this.decBrowserId();
                    ServletResponse response = this._asyncContext.getResponse();
                    ((HttpServletResponse)response).sendError(408);
                }
                catch (IOException x) {
                    LongPollingTransport.this._logger.trace("", (Throwable)x);
                }
                try {
                    this._asyncContext.complete();
                }
                catch (Exception x) {
                    LongPollingTransport.this._logger.trace("", (Throwable)x);
                }
            }
        }

        @Override
        public void schedule() {
            this.decBrowserId();
            this.dispatch();
        }

        public ServerSessionImpl getSession() {
            return this._session;
        }

        public ServerMessage.Mutable getReply() {
            Map<String, Object> advice = this._session.takeAdvice(LongPollingTransport.this);
            if (advice != null) {
                this._reply.put((Object)"advice", advice);
            }
            return this._reply;
        }

        public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            this._expired = false;
        }

        public void onComplete(AsyncEvent asyncEvent) throws IOException {
        }

        public void onTimeout(AsyncEvent asyncEvent) throws IOException {
            this._expired = true;
            this.decBrowserId();
            this._session.setScheduler(null);
            this.dispatch();
        }

        private void dispatch() {
            this._asyncContext.dispatch();
        }

        public void onError(AsyncEvent asyncEvent) throws IOException {
        }

        private void decBrowserId() {
            LongPollingTransport.this.decBrowserId(this._browserId, this.getSession());
        }
    }
}

