/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.BatchArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesSessionExtension
implements ServerSession.Extension,
ServerSession.DeQueueListener,
ServerSession.QueueListener {
    private static final Logger _logger = LoggerFactory.getLogger(AcknowledgedMessagesSessionExtension.class);
    private final Map<Long, Long> _batches = new HashMap<Long, Long>();
    private final ServerSessionImpl _session;
    private final BatchArrayQueue<ServerMessage> _queue;
    private long _lastBatch;

    public AcknowledgedMessagesSessionExtension(ServerSession session) {
        this._session = (ServerSessionImpl)session;
        this._queue = new BatchArrayQueue(16, this._session.getLock());
        this._session.setMetaConnectDeliveryOnly(true);
        this._session.addListener((ServerSession.ServerSessionListener)this);
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
        Number batchValue;
        Map ext;
        if ("/meta/connect".equals(message.getChannel()) && (ext = message.getExt(false)) != null && (batchValue = (Number)ext.get("ack")) != null) {
            this.processBatch(batchValue.longValue());
            this.updateAdvice(message);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAdvice(ServerMessage.Mutable message) {
        Object object = this._session.getLock();
        synchronized (object) {
            Map advice;
            if (!this._session.hasNonLazyMessages() && this._session.getQueue().size() != this._queue.size() && (advice = message.getAdvice(true)).get("timeout") == null) {
                advice.put("timeout", 0L);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Forcing advice: { timeout: 0 } for {}", (Object)this._session);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBatch(long batch) {
        Object object = this._session.getLock();
        synchronized (object) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Processing batch: last={}, client={}, server={} for {}", new Object[]{this._lastBatch, batch, this._queue.getBatch(), this._session});
            }
            this._lastBatch = batch;
            this._queue.clearToBatch(batch);
        }
    }

    public ServerMessage send(ServerSession session, ServerMessage message) {
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queued(ServerSession sender, ServerMessage message) {
        Object object = this._session.getLock();
        synchronized (object) {
            this._queue.offer(message);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Stored at batch {} {} for {}", new Object[]{this._queue.getBatch(), message, this._session});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        String channel = message.getChannel();
        Map ext = message.getExt(true);
        if (channel.equals("/meta/handshake")) {
            BayeuxServerImpl bayeuxServer = this._session.getBayeuxServer();
            ServerTransport transport = bayeuxServer.getCurrentTransport();
            if (this.allowMessageDeliveryDuringHandshake(this._session, transport)) {
                long size;
                long batch;
                Object object = this._session.getLock();
                synchronized (object) {
                    batch = this.closeBatch();
                    size = this._queue.batchSize(batch);
                }
                if (size == 0L) {
                    ext.put("ack", Boolean.TRUE);
                } else {
                    HashMap<String, Comparable<Boolean>> ack = new HashMap<String, Comparable<Boolean>>(3);
                    ack.put("enabled", Boolean.valueOf(true));
                    ack.put("batch", Long.valueOf(batch));
                    ack.put("size", Long.valueOf(size));
                    ext.put("ack", ack);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Sending batch {} for {}", (Object)batch, (Object)this._session);
                    }
                }
            } else {
                ext.put("ack", Boolean.TRUE);
            }
        } else if (channel.equals("/meta/connect")) {
            long batch = this.closeBatch();
            ext.put("ack", batch);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Sending batch {} for {}", (Object)batch, (Object)this._session);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long closeBatch() {
        Object object = this._session.getLock();
        synchronized (object) {
            long batch = this._queue.getBatch();
            this._batches.put(Thread.currentThread().getId(), batch);
            this._queue.nextBatch();
            return batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deQueue(ServerSession session, Queue<ServerMessage> queue) {
        Object object = this._session.getLock();
        synchronized (object) {
            Long batch = this._batches.remove(Thread.currentThread().getId());
            if (_logger.isDebugEnabled()) {
                _logger.debug("Dequeuing {}/{} messages until batch {} for {}", new Object[]{queue.size(), this._queue.size(), batch, this._session});
            }
            queue.clear();
            this._queue.exportMessagesToBatch(queue, batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importMessages(ServerSessionImpl session) {
        Object object = this._session.getLock();
        synchronized (object) {
            this._queue.addAll(session.getQueue());
        }
    }

    BatchArrayQueue<ServerMessage> getBatchArrayQueue() {
        return this._queue;
    }

    private boolean allowMessageDeliveryDuringHandshake(ServerSessionImpl session, ServerTransport transport) {
        if (session.isAllowMessageDeliveryDuringHandshake()) {
            return true;
        }
        if (transport instanceof AbstractServerTransport) {
            return ((AbstractServerTransport)transport).isAllowMessageDeliveryDuringHandshake();
        }
        return false;
    }
}

