/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.eclipse.jetty.util.ArrayQueue;

public class BatchArrayQueue<T>
extends ArrayQueue<T> {
    private long[] batches;
    private long batch;

    public BatchArrayQueue(int initial, Object lock) {
        super(initial, initial, lock);
        this.batches = new long[initial];
        this.batch = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(T t) {
        Object object = this._lock;
        synchronized (object) {
            boolean result = super.offer(t);
            if (result) {
                int newHead = this._nextE;
                int newSize = this._size;
                int oldTail = (newHead + newSize - 1) % this.getCapacity();
                this.batches[oldTail] = this.batch;
            }
            return result;
        }
    }

    public boolean add(T t) {
        return this.offer(t);
    }

    public void addUnsafe(T t) {
        throw new UnsupportedOperationException();
    }

    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll() {
        Object object = this._lock;
        synchronized (object) {
            int head = this._nextE;
            Object result = super.poll();
            if (result != null) {
                this.batches[head] = 0L;
            }
            return (T)result;
        }
    }

    public T remove() {
        T result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            super.clear();
            Arrays.fill(this.batches, 0L);
            this.batch = 1L;
        }
    }

    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBatch() {
        Object object = this._lock;
        synchronized (object) {
            return this.batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBatch() {
        Object object = this._lock;
        synchronized (object) {
            ++this.batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToBatch(long batch) {
        Object object = this._lock;
        synchronized (object) {
            int head;
            while (this.batches[head = this._nextE] <= batch && this.poll() != null) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMessagesToBatch(Queue<T> target, long batch) {
        Object object = this._lock;
        synchronized (object) {
            int cursor;
            if (this.isEmpty()) {
                return;
            }
            for (int index = 0; index < this._size && this.batches[cursor = (this._nextE + index) % this.getCapacity()] <= batch; ++index) {
                Object element = this.getUnsafe(index);
                target.offer(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchSize(long value) {
        Object object = this._lock;
        synchronized (object) {
            int result = 0;
            for (int index = 0; index < this._size; ++index) {
                int cursor = (this._nextE + index) % this.getCapacity();
                long batch = this.batches[cursor];
                if (batch == value) {
                    ++result;
                    continue;
                }
                if (batch > value) break;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean grow() {
        Object object = this._lock;
        synchronized (object) {
            int head = this._nextE;
            int tail = this._nextSlot;
            if (!super.grow()) {
                return false;
            }
            long[] newIds = new long[this._elements.length];
            int length = this.batches.length - head;
            if (length > 0) {
                System.arraycopy(this.batches, head, newIds, 0, length);
            }
            if (head != 0) {
                System.arraycopy(this.batches, 0, newIds, length, tail);
            }
            this.batches = newIds;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long batchOf(int index) {
        Object object = this._lock;
        synchronized (object) {
            int cursor = (this._nextE + index) % this.getCapacity();
            return this.batches[cursor];
        }
    }
}

