/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.AbstractClientSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;

public class LocalSessionImpl
extends AbstractClientSession
implements LocalSession {
    private final Queue<ServerMessage.Mutable> _queue = new ConcurrentLinkedQueue<ServerMessage.Mutable>();
    private final BayeuxServerImpl _bayeux;
    private final String _idHint;
    private ServerSessionImpl _session;
    private String _sessionId;

    protected LocalSessionImpl(BayeuxServerImpl bayeux, String idHint) {
        this._bayeux = bayeux;
        this._idHint = idHint;
    }

    public void receive(Message.Mutable message) {
        super.receive(message);
        if ("/meta/disconnect".equals(message.getChannel()) && message.isSuccessful()) {
            this._session = null;
        }
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new LocalChannel(channelId);
    }

    protected ChannelId newChannelId(String channelId) {
        return this._bayeux.newChannelId(channelId);
    }

    protected void sendBatch() {
        int size = this._queue.size();
        while (size-- > 0) {
            ServerMessage.Mutable message = this._queue.poll();
            this.doSend(this._session, message);
        }
    }

    public ServerSession getServerSession() {
        if (this._session == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._session;
    }

    public void handshake() {
        this.handshake(null);
    }

    public void handshake(Map<String, Object> template) {
        this.handshake(template, null);
    }

    public void handshake(Map<String, Object> template, ClientSessionChannel.MessageListener callback) {
        if (this._session != null) {
            throw new IllegalStateException();
        }
        ServerSessionImpl session = new ServerSessionImpl(this._bayeux, this, this._idHint);
        ServerMessage.Mutable message = this.newMessage();
        if (template != null) {
            message.putAll(template);
        }
        String messageId = this.newMessageId();
        message.setId(messageId);
        message.setChannel("/meta/handshake");
        this.registerCallback(messageId, callback);
        this.doSend(session, message);
        ServerMessage.Mutable reply = message.getAssociated();
        if (reply != null && reply.isSuccessful()) {
            message = this.newMessage();
            message.setId(this.newMessageId());
            message.setChannel("/meta/connect");
            message.getAdvice(true).put("interval", -1L);
            message.setClientId(session.getId());
            this.doSend(session, message);
            reply = message.getAssociated();
            if (reply != null && reply.isSuccessful()) {
                this._session = session;
                this._sessionId = session.getId();
            }
        }
    }

    public void disconnect() {
        this.disconnect(null);
    }

    public void disconnect(ClientSessionChannel.MessageListener callback) {
        if (this._session != null) {
            ServerMessage.Mutable message = this.newMessage();
            String messageId = this.newMessageId();
            message.setId(messageId);
            message.setChannel("/meta/disconnect");
            message.setClientId(this._session.getId());
            this.registerCallback(messageId, callback);
            this.send((Message.Mutable)message);
            while (this.isBatching()) {
                this.endBatch();
            }
        }
    }

    public String getId() {
        if (this._sessionId == null) {
            throw new IllegalStateException("Method handshake() not invoked for local session " + (Object)((Object)this));
        }
        return this._sessionId;
    }

    public boolean isConnected() {
        return this._session != null && this._session.isConnected();
    }

    public boolean isHandshook() {
        return this._session != null && this._session.isHandshook();
    }

    public String toString() {
        return "L:" + (this._sessionId == null ? this._idHint + "_<disconnected>" : this._sessionId);
    }

    protected void send(Message.Mutable message) {
        if (message instanceof ServerMessage.Mutable) {
            this.send(this._session, (ServerMessage.Mutable)message);
        } else {
            ServerMessage.Mutable mutable = this.newMessage();
            mutable.putAll((Map)message);
            this.send(this._session, mutable);
        }
    }

    protected void send(ServerSessionImpl session, ServerMessage.Mutable message) {
        if (this.isBatching()) {
            this._queue.add(message);
        } else {
            this.doSend(session, message);
        }
    }

    protected void doSend(ServerSessionImpl from, ServerMessage.Mutable message) {
        String messageId = message.getId();
        message.setClientId(this._sessionId);
        if (!this.extendSend((Message.Mutable)message)) {
            return;
        }
        message.setId(messageId);
        ServerMessage.Mutable reply = this._bayeux.handle(from, message);
        if (reply != null && (reply = this._bayeux.extendReply(from, this._session, reply)) != null) {
            this.receive((Message.Mutable)reply);
        }
    }

    protected ServerMessage.Mutable newMessage() {
        return this._bayeux.newMessage();
    }

    protected class LocalChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected LocalChannel(ChannelId channelId) {
            super((AbstractClientSession)LocalSessionImpl.this, channelId);
        }

        public ClientSession getSession() {
            this.throwIfReleased();
            return LocalSessionImpl.this;
        }
    }
}

