/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.AbstractHttpTransport;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class AsyncJSONTransport
extends AbstractHttpTransport {
    private static final String PREFIX = "long-polling.json";
    private static final String NAME = "long-polling";
    private static final int BUFFER_CAPACITY = 512;
    private static final ThreadLocal<byte[]> buffers = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[512];
        }
    };

    public AsyncJSONTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        request.setCharacterEncoding(encoding);
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(0L);
        Charset charset = Charset.forName(encoding);
        AbstractReader reader = "UTF-8".equals(charset.name()) ? new UTF8Reader(request, response, asyncContext) : new CharsetReader(request, response, asyncContext, charset);
        ServletInputStream input = request.getInputStream();
        input.setReadListener((ReadListener)reader);
    }

    @Override
    protected AbstractHttpTransport.HttpScheduler suspend(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
        AsyncContext asyncContext = request.getAsyncContext();
        return this.newHttpScheduler(request, response, asyncContext, session, reply, timeout);
    }

    protected AbstractHttpTransport.HttpScheduler newHttpScheduler(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
        return new AsyncLongPollScheduler(request, response, asyncContext, session, reply, timeout);
    }

    @Override
    protected void write(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, boolean scheduleExpiration, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
        AsyncContext asyncContext = request.getAsyncContext();
        try {
            response.setContentType("application/json;charset=UTF-8");
            ServletOutputStream output = response.getOutputStream();
            output.setWriteListener((WriteListener)new Writer(request, response, asyncContext, session, scheduleExpiration, messages, replies));
        }
        catch (Exception x) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Exception while writing messages", (Throwable)x);
            }
            this.error(request, response, asyncContext, 500);
        }
    }

    private class AsyncLongPollScheduler
    extends AbstractHttpTransport.LongPollScheduler {
        private AsyncLongPollScheduler(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
            super(request, response, asyncContext, session, reply, timeout);
        }

        @Override
        protected void dispatch() {
            AsyncJSONTransport.this.resume(this.getRequest(), this.getResponse(), this.getAsyncContext(), this.getServerSession(), this.getMetaConnectReply());
        }
    }

    private static enum State {
        BEGIN,
        HANDSHAKE,
        MESSAGES,
        REPLIES,
        END,
        COMPLETE;

    }

    protected class Writer
    implements WriteListener {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AsyncContext asyncContext;
        private final ServerSessionImpl session;
        private final boolean scheduleExpiration;
        private final List<ServerMessage> messages;
        private final ServerMessage.Mutable[] replies;
        private int messageIndex;
        private int replyIndex;
        private boolean needsComma;
        private State state = State.BEGIN;

        protected Writer(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, boolean scheduleExpiration, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
            this.request = request;
            this.response = response;
            this.asyncContext = asyncContext;
            this.session = session;
            this.scheduleExpiration = scheduleExpiration;
            this.messages = messages;
            this.replies = replies;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onWritePossible() throws IOException {
            ServletOutputStream output = this.response.getOutputStream();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Messages/replies {}/{} to write for session {}", new Object[]{this.messages.size(), this.replies.length, this.session});
            }
            block8: while (true) {
                switch (this.state) {
                    case BEGIN: {
                        this.state = State.HANDSHAKE;
                        if (this.writeBegin(output)) continue block8;
                        return;
                    }
                    case HANDSHAKE: {
                        this.state = State.MESSAGES;
                        if (this.writeHandshakeReply(output)) continue block8;
                        return;
                    }
                    case MESSAGES: {
                        if (!this.writeMessages(output)) {
                            return;
                        }
                        this.state = State.REPLIES;
                        continue block8;
                    }
                    case REPLIES: {
                        if (!this.writeReplies(output)) {
                            return;
                        }
                        this.state = State.END;
                        continue block8;
                    }
                    case END: {
                        this.state = State.COMPLETE;
                        if (!this.writeEnd(output)) return;
                        continue block8;
                    }
                    case COMPLETE: {
                        this.asyncContext.complete();
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        private boolean writeBegin(ServletOutputStream output) throws IOException {
            output.write(91);
            return output.isReady();
        }

        private boolean writeHandshakeReply(ServletOutputStream output) throws IOException {
            ServerMessage.Mutable reply;
            if (this.replies.length > 0 && "/meta/handshake".equals((reply = this.replies[0]).getChannel())) {
                if (AsyncJSONTransport.this.allowMessageDeliveryDuringHandshake(this.session) && !this.messages.isEmpty()) {
                    reply.put((Object)"x-messages", (Object)this.messages.size());
                }
                AsyncJSONTransport.this.getBayeux().freeze(reply);
                output.write(AsyncJSONTransport.this.toJSONBytes((ServerMessage)reply, "UTF-8"));
                this.needsComma = true;
                ++this.replyIndex;
            }
            return output.isReady();
        }

        private boolean writeMessages(ServletOutputStream output) throws IOException {
            try {
                int size = this.messages.size();
                while (output.isReady()) {
                    if (this.messageIndex == size) {
                        this.startExpiration();
                        return true;
                    }
                    if (this.needsComma) {
                        output.write(44);
                        this.needsComma = false;
                        continue;
                    }
                    ServerMessage message = this.messages.get(this.messageIndex);
                    output.write(AsyncJSONTransport.this.toJSONBytes(message, "UTF-8"));
                    this.needsComma = this.messageIndex < size;
                    ++this.messageIndex;
                }
                return false;
            }
            catch (Throwable x) {
                this.startExpiration();
                throw x;
            }
        }

        private void startExpiration() {
            if (this.scheduleExpiration && this.session != null && (this.session.isHandshook() || this.session.isConnected())) {
                this.session.scheduleExpiration(AsyncJSONTransport.this.getInterval());
            }
        }

        private boolean writeReplies(ServletOutputStream output) throws IOException {
            int size = this.replies.length;
            while (output.isReady()) {
                if (this.replyIndex == size) {
                    return true;
                }
                ServerMessage.Mutable reply = this.replies[this.replyIndex];
                if (reply != null) {
                    if (this.needsComma) {
                        output.write(44);
                        this.needsComma = false;
                        continue;
                    }
                    AsyncJSONTransport.this.getBayeux().freeze(reply);
                    output.write(AsyncJSONTransport.this.toJSONBytes((ServerMessage)reply, "UTF-8"));
                    this.needsComma = this.replyIndex < size;
                    ++this.replyIndex;
                    continue;
                }
                ++this.replyIndex;
            }
            return false;
        }

        private boolean writeEnd(ServletOutputStream output) throws IOException {
            output.write(93);
            return output.isReady();
        }

        public void onError(Throwable throwable) {
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Failure writing messages", throwable);
            }
            this.startExpiration();
            AsyncJSONTransport.this.error(this.request, this.response, this.asyncContext, 500);
        }
    }

    protected class CharsetReader
    extends AbstractReader {
        private byte[] content;
        private final Charset charset;
        private int count;

        public CharsetReader(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, Charset charset) {
            super(request, response, asyncContext);
            this.content = new byte[512];
            this.charset = charset;
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            int size;
            int newSize = size = this.content.length;
            while (newSize - this.count < length) {
                newSize <<= 1;
            }
            if (newSize < 0) {
                throw new IllegalArgumentException("Message too large");
            }
            if (newSize != size) {
                byte[] newContent = new byte[newSize];
                System.arraycopy(this.content, 0, newContent, 0, this.count);
                this.content = newContent;
            }
            System.arraycopy(buffer, offset, this.content, this.count, length);
            this.count += length;
        }

        @Override
        protected String finish() {
            return new String(this.content, 0, this.count, this.charset);
        }
    }

    protected class UTF8Reader
    extends AbstractReader {
        private final Utf8StringBuilder content;

        protected UTF8Reader(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext) {
            super(request, response, asyncContext);
            this.content = new Utf8StringBuilder(512);
        }

        @Override
        protected void append(byte[] buffer, int offset, int length) {
            this.content.append(buffer, offset, length);
        }

        @Override
        protected String finish() {
            return this.content.toString();
        }
    }

    protected abstract class AbstractReader
    implements ReadListener {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        protected final AsyncContext asyncContext;

        protected AbstractReader(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext) {
            this.request = request;
            this.response = response;
            this.asyncContext = asyncContext;
        }

        public void onDataAvailable() throws IOException {
            ServletInputStream input = this.request.getInputStream();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read start from {}", (Object)input);
            }
            byte[] buffer = (byte[])buffers.get();
            while (input.isReady() && !input.isFinished()) {
                int read = input.read(buffer);
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Asynchronous read {} bytes from {}", (Object)read, (Object)input);
                }
                if (read < 0) continue;
                this.append(buffer, 0, read);
            }
            if (!input.isFinished() && AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read pending from {}", (Object)input);
            }
        }

        protected abstract void append(byte[] var1, int var2, int var3);

        public void onAllDataRead() throws IOException {
            ServletInputStream input = this.request.getInputStream();
            String json = this.finish();
            if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                AsyncJSONTransport.this._logger.debug("Asynchronous read end from {}: {}", (Object)input, (Object)json);
            }
            this.process(json);
        }

        protected abstract String finish();

        protected void process(String json) throws IOException {
            AsyncJSONTransport.this.getBayeux().setCurrentTransport(AsyncJSONTransport.this);
            AsyncJSONTransport.this.setCurrentRequest(this.request);
            try {
                ServerMessage.Mutable[] messages = AsyncJSONTransport.this.parseMessages(json);
                if (AsyncJSONTransport.this._logger.isDebugEnabled()) {
                    AsyncJSONTransport.this._logger.debug("Parsed {} messages", (Object)(messages == null ? -1 : messages.length));
                }
                if (messages != null) {
                    AsyncJSONTransport.this.processMessages(this.request, this.response, messages);
                } else {
                    this.asyncContext.complete();
                }
            }
            catch (ParseException x) {
                AsyncJSONTransport.this.handleJSONParseException(this.request, this.response, json, x);
                this.asyncContext.complete();
            }
            finally {
                AsyncJSONTransport.this.setCurrentRequest(null);
                AsyncJSONTransport.this.getBayeux().setCurrentTransport(null);
            }
        }

        public void onError(Throwable throwable) {
            AsyncJSONTransport.this.error(this.request, this.response, this.asyncContext, 500);
        }
    }
}

