/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.AbstractHttpTransport;

public abstract class AbstractStreamHttpTransport
extends AbstractHttpTransport {
    private static final String SCHEDULER_ATTRIBUTE = "org.cometd.scheduler";

    protected AbstractStreamHttpTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.getBayeux().setCurrentTransport(this);
        this.setCurrentRequest(request);
        try {
            this.process(request, response);
        }
        finally {
            this.setCurrentRequest(null);
            this.getBayeux().setCurrentTransport(null);
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AbstractHttpTransport.LongPollScheduler scheduler = (AbstractHttpTransport.LongPollScheduler)request.getAttribute(SCHEDULER_ATTRIBUTE);
        if (scheduler == null) {
            try {
                ServerMessage.Mutable[] messages = this.parseMessages(request);
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Parsed {} messages", (Object)(messages == null ? -1 : messages.length));
                }
                if (messages != null) {
                    this.processMessages(request, response, messages);
                }
            }
            catch (ParseException x) {
                this.handleJSONParseException(request, response, x.getMessage(), x.getCause());
            }
        } else {
            this.resume(request, response, null, scheduler.getServerSession(), scheduler.getMetaConnectReply());
        }
    }

    @Override
    protected AbstractHttpTransport.HttpScheduler suspend(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(0L);
        AbstractHttpTransport.HttpScheduler scheduler = this.newHttpScheduler(request, response, asyncContext, session, reply, timeout);
        request.setAttribute(SCHEDULER_ATTRIBUTE, (Object)scheduler);
        return scheduler;
    }

    protected AbstractHttpTransport.HttpScheduler newHttpScheduler(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
        return new DispatchingLongPollScheduler(request, response, asyncContext, session, reply, timeout);
    }

    protected abstract ServerMessage.Mutable[] parseMessages(HttpServletRequest var1) throws IOException, ParseException;

    protected ServerMessage.Mutable[] parseMessages(String[] requestParameters) throws IOException, ParseException {
        if (requestParameters == null || requestParameters.length == 0) {
            throw new IOException("Missing 'message' request parameter");
        }
        if (requestParameters.length == 1) {
            return this.parseMessages(requestParameters[0]);
        }
        ArrayList<ServerMessage.Mutable> messages = new ArrayList<ServerMessage.Mutable>();
        for (String batch : requestParameters) {
            ServerMessage.Mutable[] parsed;
            if (batch == null || (parsed = this.parseMessages(batch)) == null) continue;
            messages.addAll(Arrays.asList(parsed));
        }
        return messages.toArray(new ServerMessage.Mutable[messages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, boolean scheduleExpiration, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
        try {
            ServletOutputStream output;
            int replyIndex = 0;
            boolean needsComma = false;
            try {
                ServerMessage.Mutable reply;
                output = this.beginWrite(request, response);
                if (replies.length > 0 && "/meta/handshake".equals((reply = replies[0]).getChannel())) {
                    if (this.allowMessageDeliveryDuringHandshake(session) && !messages.isEmpty()) {
                        reply.put((Object)"x-messages", (Object)messages.size());
                    }
                    this.getBayeux().freeze(reply);
                    this.writeMessage(response, output, session, (ServerMessage)reply);
                    needsComma = true;
                    ++replyIndex;
                }
                for (int i = 0; i < messages.size(); ++i) {
                    ServerMessage message = messages.get(i);
                    if (needsComma) {
                        output.write(44);
                    }
                    needsComma = true;
                    this.writeMessage(response, output, session, message);
                }
            }
            finally {
                if (scheduleExpiration && session != null && (session.isHandshook() || session.isConnected())) {
                    session.scheduleExpiration(this.getInterval());
                }
            }
            while (replyIndex < replies.length) {
                ServerMessage.Mutable reply = replies[replyIndex];
                if (reply != null) {
                    if (needsComma) {
                        output.write(44);
                    }
                    needsComma = true;
                    this.getBayeux().freeze(reply);
                    this.writeMessage(response, output, session, (ServerMessage)reply);
                }
                ++replyIndex;
            }
            this.endWrite(response, output);
            this.writeComplete(request, response, session, messages, replies);
        }
        catch (Exception x) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Failure writing messages", (Throwable)x);
            }
            AsyncContext asyncContext = null;
            if (request.isAsyncStarted()) {
                asyncContext = request.getAsyncContext();
            }
            this.error(request, response, asyncContext, 500);
        }
    }

    protected void writeMessage(HttpServletResponse response, ServletOutputStream output, ServerSessionImpl session, ServerMessage message) throws IOException {
        output.write(this.toJSONBytes(message, response.getCharacterEncoding()));
    }

    protected abstract ServletOutputStream beginWrite(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected abstract void endWrite(HttpServletResponse var1, ServletOutputStream var2) throws IOException;

    protected void writeComplete(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
    }

    protected class DispatchingLongPollScheduler
    extends AbstractHttpTransport.LongPollScheduler {
        public DispatchingLongPollScheduler(HttpServletRequest request, HttpServletResponse response, AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
            super(AbstractStreamHttpTransport.this, request, response, asyncContext, session, reply, timeout);
        }

        @Override
        protected void dispatch() {
            this.getAsyncContext().dispatch();
        }
    }
}

