/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;

public class TimestampExtension
implements BayeuxServer.Extension {
    private final String format;
    private final TimeZone timezone;

    public TimestampExtension() {
        this("EEE MMM dd HH:mm:ss zzz yyyy");
    }

    public TimestampExtension(String format) {
        this(format, TimeZone.getDefault());
    }

    public TimestampExtension(String format, TimeZone tz) {
        this.format = format;
        this.timezone = tz;
    }

    public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        this.timestamp(message);
        return true;
    }

    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        this.timestamp(message);
        return true;
    }

    private void timestamp(ServerMessage.Mutable message) {
        SimpleDateFormat formatter = new SimpleDateFormat(this.format);
        formatter.setTimeZone(this.timezone);
        message.put((Object)"timestamp", (Object)formatter.format(System.currentTimeMillis()));
    }
}

