/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.client.common;

import java.io.EOFException;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;

public abstract class AbstractWebSocketTransport
extends HttpClientTransport
implements MessageClientTransport {
    public static final String PREFIX = "ws";
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String CONNECT_TIMEOUT_OPTION = "connectTimeout";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String STICKY_RECONNECT_OPTION = "stickyReconnect";
    private ScheduledExecutorService _scheduler;
    private String _protocol;
    private long _connectTimeout;
    private long _idleTimeout;
    private boolean _stickyReconnect;
    private Delegate _delegate;
    private TransportListener _listener;

    protected AbstractWebSocketTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler) {
        super(NAME, url, options);
        this._scheduler = scheduler;
        this.setOptionPrefix(PREFIX);
    }

    public void setMessageTransportListener(TransportListener listener) {
        this._listener = listener;
    }

    public void setURL(String url) {
        super.setURL(url.replaceFirst("^http", PREFIX));
    }

    public void init() {
        super.init();
        if (this._scheduler == null) {
            int threads = Math.max(1, Runtime.getRuntime().availableProcessors() / 4);
            this._scheduler = new WebSocketTransportScheduler(threads);
        }
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this.setMaxNetworkDelay(15000L);
        this._connectTimeout = 30000L;
        this._idleTimeout = 60000L;
        this._stickyReconnect = this.getOption(STICKY_RECONNECT_OPTION, true);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public long getIdleTimeout() {
        this._idleTimeout = this.getOption(IDLE_TIMEOUT_OPTION, this._idleTimeout);
        return this._idleTimeout;
    }

    public long getConnectTimeout() {
        this._connectTimeout = this.getOption(CONNECT_TIMEOUT_OPTION, this._connectTimeout);
        return this._connectTimeout;
    }

    public boolean isStickyReconnect() {
        return this._stickyReconnect;
    }

    public void abort() {
        Delegate delegate = this.getDelegate();
        if (delegate != null) {
            delegate.abort();
        }
        this.shutdownScheduler();
    }

    public void terminate() {
        Delegate delegate = this.getDelegate();
        if (delegate != null) {
            delegate.terminate();
        }
        this.shutdownScheduler();
        super.terminate();
    }

    private void shutdownScheduler() {
        if (this._scheduler instanceof WebSocketTransportScheduler) {
            this._scheduler.shutdown();
            this._scheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Delegate getDelegate() {
        AbstractWebSocketTransport abstractWebSocketTransport = this;
        synchronized (abstractWebSocketTransport) {
            return this._delegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TransportListener listener, List<Message.Mutable> messages) {
        Delegate delegate = this.getDelegate();
        if (delegate == null) {
            String url = this.getURL();
            delegate = this.connect(url = url.replaceFirst("^http", PREFIX), listener, messages);
            if (delegate == null) {
                return;
            }
            AbstractWebSocketTransport abstractWebSocketTransport = this;
            synchronized (abstractWebSocketTransport) {
                if (this._delegate != null) {
                    delegate.shutdown("Extra");
                    delegate = this._delegate;
                }
                this._delegate = delegate;
            }
        }
        delegate.registerMessages(listener, messages);
        try {
            String content = this.generateJSON(messages);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending messages {}", (Object)content);
            }
            listener.onSending(messages);
            delegate.send(content);
        }
        catch (Throwable x) {
            delegate.fail(x, "Exception");
        }
    }

    protected abstract Delegate connect(String var1, TransportListener var2, List<Message.Mutable> var3);

    protected void storeCookies(Map<String, List<String>> headers) {
        block2: {
            try {
                CookieManager cookieManager = new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
                cookieManager.put(URI.create(this.getURL()), headers);
            }
            catch (IOException x) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Could not parse cookies", (Throwable)x);
            }
        }
    }

    private static class WebSocketTransportScheduler
    extends ScheduledThreadPoolExecutor {
        public WebSocketTransportScheduler(int threads) {
            super(threads);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.setRemoveOnCancelPolicy(true);
        }
    }

    private static class WebSocketExchange {
        private final Message.Mutable message;
        private final TransportListener listener;
        private final ScheduledFuture<?> task;

        public WebSocketExchange(Message.Mutable message, TransportListener listener, ScheduledFuture<?> task) {
            this.message = message;
            this.listener = listener;
            this.task = task;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.message;
        }
    }

    protected abstract class Delegate {
        private final Map<String, WebSocketExchange> _exchanges = new ConcurrentHashMap<String, WebSocketExchange>();
        private boolean _connected;
        private boolean _disconnected;
        private Map<String, Object> _advice;

        protected Delegate() {
        }

        protected void onClose(int code, String reason) {
            if (this.detach()) {
                if (AbstractWebSocketTransport.this.logger.isDebugEnabled()) {
                    AbstractWebSocketTransport.this.logger.debug("Closed websocket connection {}/{}", (Object)code, (Object)reason);
                }
                this.close();
                this.failMessages(new EOFException("Connection closed " + code + " " + reason));
            }
        }

        protected void onData(String data) {
            try {
                List messages = AbstractWebSocketTransport.this.parseMessages(data);
                if (this.isAttached()) {
                    if (AbstractWebSocketTransport.this.logger.isDebugEnabled()) {
                        AbstractWebSocketTransport.this.logger.debug("Received messages {}", (Object)data);
                    }
                    this.onMessages(messages);
                } else if (AbstractWebSocketTransport.this.logger.isDebugEnabled()) {
                    AbstractWebSocketTransport.this.logger.debug("Discarded messages {}", (Object)data);
                }
            }
            catch (ParseException x) {
                this.fail(x, "Exception");
            }
        }

        protected void onMessages(List<Message.Mutable> messages) {
            for (Message.Mutable message : messages) {
                if (this.isReply((Message)message)) {
                    WebSocketExchange exchange;
                    Map advice;
                    if ("/meta/connect".equals(message.getChannel()) && message.isSuccessful() && (advice = message.getAdvice()) != null && advice.get("timeout") != null) {
                        this._advice = advice;
                    }
                    if ((exchange = this.deregisterMessage((Message)message)) != null) {
                        exchange.listener.onMessages(Collections.singletonList(message));
                    } else if (AbstractWebSocketTransport.this.logger.isDebugEnabled()) {
                        AbstractWebSocketTransport.this.logger.debug("Could not find request for reply {}", (Object)message);
                    }
                    if (!this._disconnected || this._connected) continue;
                    this.disconnect("Disconnect");
                    continue;
                }
                AbstractWebSocketTransport.this._listener.onMessages(Collections.singletonList(message));
            }
        }

        private boolean isReply(Message message) {
            if (message.isPublishReply()) {
                return true;
            }
            if (message.isMeta()) {
                return !"/meta/disconnect".equals(message.getChannel()) || message.getId() != null;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerMessages(TransportListener listener, List<Message.Mutable> messages) {
            boolean open;
            Delegate delegate = this;
            synchronized (delegate) {
                open = this.isOpen();
                if (open) {
                    for (Message.Mutable message : messages) {
                        this.registerMessage(message, listener);
                    }
                }
            }
            if (!open) {
                listener.onFailure((Throwable)new IOException("Unconnected"), messages);
            }
        }

        private void registerMessage(final Message.Mutable message, TransportListener listener) {
            WebSocketExchange existing;
            long maxNetworkDelay = AbstractWebSocketTransport.this.getMaxNetworkDelay();
            if ("/meta/connect".equals(message.getChannel())) {
                Map<String, Object> advice = message.getAdvice();
                if (advice == null) {
                    advice = this._advice;
                }
                if (advice != null) {
                    Object timeout = advice.get("timeout");
                    if (timeout instanceof Number) {
                        maxNetworkDelay += (long)((Number)timeout).intValue();
                    } else if (timeout != null) {
                        maxNetworkDelay += (long)Integer.parseInt(timeout.toString());
                    }
                }
                this._connected = true;
            }
            final long expiration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + maxNetworkDelay;
            ScheduledFuture<?> task = AbstractWebSocketTransport.this._scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    long delay = now - expiration;
                    if (AbstractWebSocketTransport.this.logger.isDebugEnabled()) {
                        if (delay > 5000L) {
                            AbstractWebSocketTransport.this.logger.debug("Message {} expired {} ms too late", (Object)message, (Object)delay);
                        }
                        AbstractWebSocketTransport.this.logger.debug("Expiring message {}", (Object)message);
                    }
                    Delegate.this.fail(new TimeoutException(), "Expired");
                }
            }, maxNetworkDelay, TimeUnit.MILLISECONDS);
            WebSocketExchange exchange = new WebSocketExchange(message, listener, task);
            if (AbstractWebSocketTransport.this.logger.isDebugEnabled()) {
                AbstractWebSocketTransport.this.logger.debug("Registering {}", (Object)exchange);
            }
            if ((existing = this._exchanges.put(message.getId(), exchange)) != null) {
                throw new IllegalStateException();
            }
        }

        private WebSocketExchange deregisterMessage(Message message) {
            if ("/meta/connect".equals(message.getChannel())) {
                this._connected = false;
            } else if ("/meta/disconnect".equals(message.getChannel())) {
                this._disconnected = true;
            }
            WebSocketExchange exchange = null;
            String messageId = message.getId();
            if (messageId != null) {
                exchange = this._exchanges.remove(messageId);
            }
            if (AbstractWebSocketTransport.this.logger.isDebugEnabled()) {
                AbstractWebSocketTransport.this.logger.debug("Deregistering {} for message {}", (Object)exchange, (Object)message);
            }
            if (exchange != null) {
                exchange.task.cancel(false);
            }
            return exchange;
        }

        protected abstract void send(String var1);

        protected void fail(Throwable failure, String reason) {
            this.disconnect(reason);
            this.failMessages(failure);
        }

        protected void failMessages(Throwable cause) {
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            for (WebSocketExchange exchange : new ArrayList<WebSocketExchange>(this._exchanges.values())) {
                Message.Mutable message = exchange.message;
                if (this.deregisterMessage((Message)message) != exchange) continue;
                messages.add(message);
                exchange.listener.onFailure(cause, messages);
                messages.clear();
            }
        }

        private void abort() {
            this.fail(new IOException("Aborted"), "Aborted");
        }

        private void disconnect(String reason) {
            if (this.detach()) {
                this.shutdown(reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isAttached() {
            AbstractWebSocketTransport abstractWebSocketTransport = AbstractWebSocketTransport.this;
            synchronized (abstractWebSocketTransport) {
                return this == AbstractWebSocketTransport.this._delegate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean detach() {
            AbstractWebSocketTransport abstractWebSocketTransport = AbstractWebSocketTransport.this;
            synchronized (abstractWebSocketTransport) {
                boolean attached;
                boolean bl = attached = this == AbstractWebSocketTransport.this._delegate;
                if (attached) {
                    AbstractWebSocketTransport.this._delegate = null;
                }
                return attached;
            }
        }

        protected abstract boolean isOpen();

        protected abstract void close();

        protected abstract void shutdown(String var1);

        private void terminate() {
            this.fail(new EOFException(), "Terminate");
        }
    }
}

