/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.websocket.server.common.AbstractWebSocketTransport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketTransport<S>
extends AbstractServerTransport {
    public static final String NAME = "websocket";
    public static final String PREFIX = "ws";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String MESSAGES_PER_FRAME_OPTION = "messagesPerFrame";
    public static final String BUFFER_SIZE_OPTION = "bufferSize";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String COMETD_URL_MAPPING_OPTION = "cometdURLMapping";
    public static final String REQUIRE_HANDSHAKE_PER_CONNECTION_OPTION = "requireHandshakePerConnection";
    public static final String ENABLE_EXTENSION_PREFIX_OPTION = "enableExtension.";
    private final ThreadLocal<BayeuxContext> _bayeuxContext = new ThreadLocal();
    private ScheduledExecutorService _scheduler;
    private String _protocol;
    private int _messagesPerFrame;
    private boolean _requireHandshakePerConnection;

    protected AbstractWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    public void init() {
        super.init();
        this._scheduler = this.newScheduledExecutor();
        this._protocol = this.getOption(PROTOCOL_OPTION, null);
        this._messagesPerFrame = this.getOption(MESSAGES_PER_FRAME_OPTION, 1);
        this._requireHandshakePerConnection = this.getOption(REQUIRE_HANDSHAKE_PER_CONNECTION_OPTION, false);
    }

    public void destroy() {
        this._scheduler.shutdown();
        super.destroy();
    }

    protected ScheduledExecutorService newScheduledExecutor() {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    public ScheduledExecutorService getScheduler() {
        return this._scheduler;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public int getMessagesPerFrame() {
        return this._messagesPerFrame;
    }

    protected boolean checkProtocol(List<String> serverProtocols, List<String> clientProtocols) {
        if (serverProtocols.isEmpty()) {
            return true;
        }
        for (String clientProtocol : clientProtocols) {
            if (!serverProtocols.contains(clientProtocol)) continue;
            return true;
        }
        return false;
    }

    public BayeuxContext getContext() {
        return this._bayeuxContext.get();
    }

    protected List<String> normalizeURLMapping(String urlMapping) {
        String[] mappings = urlMapping.split(",");
        ArrayList<String> result = new ArrayList<String>(mappings.length);
        for (String mapping : mappings) {
            if (mapping.endsWith("/*")) {
                mapping = mapping.substring(0, mapping.length() - 2);
            }
            if (!mapping.startsWith("/")) {
                mapping = "/" + mapping;
            }
            result.add(mapping);
        }
        return result;
    }

    protected void handleJSONParseException(S wsSession, ServerSession session, String json, Throwable exception) {
        this._logger.warn("Error parsing JSON: " + json, exception);
    }

    protected void handleException(S wsSession, ServerSession session, Throwable exception) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("", exception);
        }
    }

    protected abstract void send(S var1, ServerSession var2, String var3, Callback var4);

    protected void onClose(int code, String reason) {
    }

    protected abstract class AbstractWebSocketScheduler
    implements AbstractServerTransport.Scheduler {
        protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
        private final org.cometd.websocket.server.common.AbstractWebSocketTransport$AbstractWebSocketScheduler.Flusher flusher = new Flusher();
        private final BayeuxContext _context;
        private volatile ServerSessionImpl _session;
        private ServerMessage.Mutable _connectReply;
        private ScheduledFuture<?> _connectTask;

        protected AbstractWebSocketScheduler(BayeuxContext context) {
            this._context = context;
        }

        protected void send(S wsSession, List<? extends ServerMessage> messages, int batchSize, Callback callback) {
            if (messages.isEmpty()) {
                callback.succeeded();
                return;
            }
            int size = messages.size();
            int batch = Math.min(batchSize, size);
            int capacity = batch * 4 * 48;
            StringBuilder builder = new StringBuilder(capacity);
            builder.append("[");
            if (batch == 1) {
                ServerMessage serverMessage = messages.remove(0);
                builder.append(serverMessage.getJSON());
            } else {
                boolean comma = false;
                for (int b = 0; b < batch; ++b) {
                    ServerMessage serverMessage = messages.get(b);
                    if (comma) {
                        builder.append(",");
                    }
                    comma = true;
                    builder.append(serverMessage.getJSON());
                }
                if (batch == size) {
                    messages.clear();
                } else {
                    messages.subList(0, batch).clear();
                }
            }
            builder.append("]");
            AbstractWebSocketTransport.this.send(wsSession, (ServerSession)this._session, builder.toString(), callback);
        }

        public void onClose(int code, String reason) {
            ServerSessionImpl session = this._session;
            if (session != null) {
                this._session = null;
                session.scheduleExpiration(AbstractWebSocketTransport.this.getInterval());
                this.cancelMetaConnectTask(session);
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Closing {}/{} - {}", new Object[]{code, reason, session});
            }
            AbstractWebSocketTransport.this.onClose(code, reason);
        }

        public void onError(Throwable failure) {
            if (failure instanceof SocketTimeoutException || failure instanceof TimeoutException) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("WebSocket Timeout", failure);
                }
            } else {
                BayeuxContext context = AbstractWebSocketTransport.this.getContext();
                InetSocketAddress address = context == null ? null : context.getRemoteAddress();
                this._logger.info("WebSocket Error, Address: " + address, failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean cancelMetaConnectTask(ServerSessionImpl session) {
            ScheduledFuture<?> connectTask;
            Object object = session.getLock();
            synchronized (object) {
                connectTask = this._connectTask;
                this._connectTask = null;
            }
            if (connectTask == null) {
                return false;
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Cancelling meta connect task {}", connectTask);
            }
            connectTask.cancel(false);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(S wsSession, String data) {
            AbstractWebSocketTransport.this._bayeuxContext.set(this._context);
            AbstractWebSocketTransport.this.getBayeux().setCurrentTransport((ServerTransport)AbstractWebSocketTransport.this);
            try {
                ServerMessage.Mutable[] messages = AbstractWebSocketTransport.this.parseMessages(data);
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Parsed {} messages", (Object)(messages == null ? -1 : messages.length));
                }
                if (messages != null) {
                    this.processMessages(wsSession, messages);
                }
            }
            catch (ParseException x) {
                this.close(1011, x.toString());
                AbstractWebSocketTransport.this.handleJSONParseException(wsSession, (ServerSession)this._session, data, x);
            }
            catch (Throwable x) {
                this.close(1011, x.toString());
                AbstractWebSocketTransport.this.handleException(wsSession, (ServerSession)this._session, x);
            }
            finally {
                AbstractWebSocketTransport.this._bayeuxContext.set(null);
                AbstractWebSocketTransport.this.getBayeux().setCurrentTransport(null);
            }
        }

        private void processMessages(S wsSession, ServerMessage.Mutable[] messages) throws IOException {
            if (messages.length == 0) {
                throw new IOException();
            }
            ServerSessionImpl session = this._session;
            if (session == null) {
                ServerMessage.Mutable message = messages[0];
                if ("/meta/handshake".equals(message.getChannel())) {
                    session = AbstractWebSocketTransport.this.getBayeux().newServerSession();
                } else if (!AbstractWebSocketTransport.this._requireHandshakePerConnection) {
                    this._session = session = (ServerSessionImpl)AbstractWebSocketTransport.this.getBayeux().getSession(message.getClientId());
                }
            } else if (session.isDisconnected()) {
                session = null;
                this._session = null;
            }
            boolean sendQueue = false;
            boolean sendReplies = false;
            boolean scheduleExpiration = false;
            ArrayList<ServerMessage.Mutable> replies = new ArrayList<ServerMessage.Mutable>(messages.length);
            block8: for (ServerMessage.Mutable message : messages) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Processing {}", (Object)message);
                }
                switch (message.getChannel()) {
                    case "/meta/handshake": {
                        if (messages.length > 1) {
                            throw new IOException();
                        }
                        ServerMessage.Mutable reply = this.processMetaHandshake(session, message);
                        if (reply.isSuccessful()) {
                            this._session = session;
                        }
                        if ((reply = AbstractWebSocketTransport.this.processReply(session, reply)) != null) {
                            replies.add(reply);
                        }
                        sendQueue = AbstractWebSocketTransport.this.allowMessageDeliveryDuringHandshake(session) && reply != null && reply.isSuccessful();
                        sendReplies = reply != null;
                        scheduleExpiration = true;
                        continue block8;
                    }
                    case "/meta/connect": {
                        ServerMessage.Mutable reply = this.processMetaConnect(session, message);
                        reply = AbstractWebSocketTransport.this.processReply(session, reply);
                        if (reply != null) {
                            replies.add(reply);
                        }
                        boolean deliver = AbstractWebSocketTransport.this.isMetaConnectDeliveryOnly() || session != null && session.isMetaConnectDeliveryOnly();
                        sendQueue = deliver && reply != null;
                        sendReplies = reply != null;
                        scheduleExpiration = true;
                        continue block8;
                    }
                    default: {
                        ServerMessage.Mutable reply = AbstractWebSocketTransport.this.getBayeux().handle(session, message);
                        reply = AbstractWebSocketTransport.this.processReply(session, reply);
                        if (reply != null) {
                            replies.add(reply);
                        }
                        if (reply == null) continue block8;
                        sendReplies = true;
                        continue block8;
                    }
                }
            }
            if (sendQueue || sendReplies) {
                this.send(wsSession, session, sendQueue, scheduleExpiration, replies);
            }
        }

        private ServerMessage.Mutable processMetaHandshake(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = AbstractWebSocketTransport.this.getBayeux().handle(session, message);
            if (reply.isSuccessful()) {
                session.setScheduler((AbstractServerTransport.Scheduler)this);
            }
            return reply;
        }

        private ServerMessage.Mutable processMetaConnect(ServerSessionImpl session, ServerMessage.Mutable message) {
            boolean wasConnected = session != null && session.isConnected();
            ServerMessage.Mutable reply = AbstractWebSocketTransport.this.getBayeux().handle(session, message);
            if (session != null) {
                if (reply.isSuccessful() && session.isConnected()) {
                    boolean replyToMetaConnect;
                    session.setScheduler((AbstractServerTransport.Scheduler)this);
                    boolean metaConnectDelivery = AbstractWebSocketTransport.this.isMetaConnectDeliveryOnly() || session.isMetaConnectDeliveryOnly();
                    boolean hasMessages = session.hasNonLazyMessages();
                    boolean bl = replyToMetaConnect = hasMessages && metaConnectDelivery;
                    if (!replyToMetaConnect) {
                        boolean holdMetaConnect;
                        long timeout = session.calculateTimeout(AbstractWebSocketTransport.this.getTimeout());
                        boolean bl2 = holdMetaConnect = timeout > 0L && wasConnected;
                        if (holdMetaConnect) {
                            reply = this.shouldHoldMetaConnect(session, reply, timeout);
                        }
                    }
                }
                if (reply != null && session.isDisconnected()) {
                    reply.getAdvice(true).put("reconnect", "none");
                }
            }
            return reply;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerMessage.Mutable shouldHoldMetaConnect(ServerSessionImpl session, ServerMessage.Mutable reply, long timeout) {
            Object object = session.getLock();
            synchronized (object) {
                if (!session.hasNonLazyMessages()) {
                    if (this.cancelMetaConnectTask(session) && this._logger.isDebugEnabled()) {
                        this._logger.debug("Cancelled unresponded meta connect {}", (Object)this._connectReply);
                    }
                    this._connectReply = reply;
                    long expiration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout;
                    this._connectTask = AbstractWebSocketTransport.this.getScheduler().schedule(new MetaConnectReplyTask(reply, expiration), timeout, TimeUnit.MILLISECONDS);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("Scheduled meta connect {}", this._connectTask);
                    }
                    reply = null;
                }
                return reply;
            }
        }

        protected void send(S wsSession, ServerSessionImpl session, boolean sendQueue, boolean scheduleExpiration, List<ServerMessage.Mutable> replies) {
            boolean queued;
            List queue = Collections.emptyList();
            if (sendQueue && session != null) {
                queue = session.takeQueue();
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Sending {}, replies={}, messages={}", new Object[]{session, replies, queue});
            }
            if (queued = ((Flusher)this.flusher).queue(new Entry(wsSession, session, scheduleExpiration, queue, replies))) {
                this.flusher.iterate();
            }
        }

        protected abstract void close(int var1, String var2);

        public void cancel() {
            ServerSessionImpl session = this._session;
            if (session != null && this.cancelMetaConnectTask(session)) {
                this.close(1000, "Cancel");
            }
        }

        public void schedule() {
            this.schedule(false, null);
        }

        protected abstract void schedule(boolean var1, ServerMessage.Mutable var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void schedule(S wsSession, boolean timeout, ServerMessage.Mutable expiredConnectReply) {
            ServerSessionImpl session = this._session;
            try {
                ServerMessage.Mutable connectReply;
                boolean metaConnectDelivery;
                if (session == null) {
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("No session, skipping reply {}", (Object)expiredConnectReply);
                    }
                    return;
                }
                boolean bl = metaConnectDelivery = AbstractWebSocketTransport.this.isMetaConnectDeliveryOnly() || session.isMetaConnectDeliveryOnly();
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Flushing {} timeout={} metaConnectDelivery={}", new Object[]{session, timeout, metaConnectDelivery});
                }
                boolean reply = false;
                Object object = session.getLock();
                synchronized (object) {
                    connectReply = this._connectReply;
                    if (timeout && connectReply != expiredConnectReply) {
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug("Flushing skipped replies that do not match: {} != {}", (Object)connectReply, (Object)expiredConnectReply);
                        }
                        return;
                    }
                    if (connectReply == null) {
                        if (metaConnectDelivery) {
                            if (this._logger.isDebugEnabled()) {
                                this._logger.debug("Flushing skipped since metaConnectDelivery={}, metaConnectReply={}", (Object)metaConnectDelivery, (Object)connectReply);
                            }
                            return;
                        }
                    } else if (timeout || metaConnectDelivery || !session.isConnected()) {
                        this.cancelMetaConnectTask(session);
                        this._connectReply = null;
                        reply = true;
                    }
                }
                this.send(wsSession, session, reply, connectReply);
            }
            catch (Throwable x) {
                this.close(1011, x.toString());
                AbstractWebSocketTransport.this.handleException(wsSession, (ServerSession)session, x);
            }
        }

        private void send(S wsSession, ServerSessionImpl session, boolean reply, ServerMessage.Mutable connectReply) {
            List<ServerMessage.Mutable> replies = Collections.emptyList();
            if (reply) {
                if (session.isDisconnected() && connectReply != null) {
                    connectReply.getAdvice(true).put("reconnect", "none");
                }
                if ((connectReply = AbstractWebSocketTransport.this.processReply(session, connectReply)) != null) {
                    replies = new ArrayList<ServerMessage.Mutable>(1);
                    replies.add(connectReply);
                }
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Sending {} metaConnectReply={}", (Object)session, (Object)connectReply);
            }
            this.send(wsSession, session, true, reply, replies);
        }

        private class Entry<W> {
            private final W _wsSession;
            private final ServerSessionImpl _session;
            private final boolean _scheduleExpiration;
            private final List<ServerMessage> _queue;
            private final List<ServerMessage.Mutable> _replies;

            private Entry(W wsSession, ServerSessionImpl session, boolean scheduleExpiration, List<ServerMessage> queue, List<ServerMessage.Mutable> replies) {
                this._wsSession = wsSession;
                this._session = session;
                this._scheduleExpiration = scheduleExpiration;
                this._queue = queue;
                this._replies = replies;
            }

            private void scheduleExpiration() {
                if (this._scheduleExpiration && this._session != null) {
                    this._session.scheduleExpiration(AbstractWebSocketTransport.this.getInterval());
                }
            }

            public String toString() {
                return String.format("%s@%x[messages=%d,replies=%d]", this.getClass().getSimpleName(), this.hashCode(), this._queue.size(), this._replies.size());
            }
        }

        private class Flusher
        extends IteratingCallback {
            private final Queue<org.cometd.websocket.server.common.AbstractWebSocketTransport$AbstractWebSocketScheduler.Entry<S>> _entries = new ArrayDeque();
            private org.cometd.websocket.server.common.AbstractWebSocketTransport$AbstractWebSocketScheduler.Entry<S> entry;
            private boolean terminated;

            private Flusher() {
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean queue(Entry entry) {
                Flusher flusher = this;
                synchronized (flusher) {
                    if (!this.terminated) {
                        return this._entries.offer((org.cometd.websocket.server.common.AbstractWebSocketTransport$AbstractWebSocketScheduler.Entry)entry);
                    }
                }
                entry.scheduleExpiration();
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IteratingCallback.Action process() throws Exception {
                ServerMessage.Mutable reply;
                Entry entry;
                Flusher flusher = this;
                synchronized (flusher) {
                    this.entry = (Entry)this._entries.peek();
                    entry = this.entry;
                }
                if (AbstractWebSocketScheduler.this._logger.isDebugEnabled()) {
                    AbstractWebSocketScheduler.this._logger.debug("Processing {}", (Object)entry);
                }
                if (entry == null) {
                    return IteratingCallback.Action.IDLE;
                }
                Object wsSession = entry._wsSession;
                List replies = entry._replies;
                List queue = entry._queue;
                if (replies.size() > 0 && "/meta/handshake".equals((reply = (ServerMessage.Mutable)replies.get(0)).getChannel())) {
                    if (AbstractWebSocketTransport.this.allowMessageDeliveryDuringHandshake(AbstractWebSocketScheduler.this._session) && !queue.isEmpty()) {
                        reply.put((Object)"x-messages", (Object)queue.size());
                    }
                    AbstractWebSocketTransport.this.getBayeux().freeze(reply);
                    AbstractWebSocketScheduler.this.send(wsSession, replies, 1, (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (!queue.isEmpty()) {
                    int batchSize;
                    int size = queue.size();
                    int messagesPerFrame = AbstractWebSocketTransport.this.getMessagesPerFrame();
                    int n = batchSize = messagesPerFrame > 0 ? Math.min(messagesPerFrame, size) : size;
                    if (AbstractWebSocketScheduler.this._logger.isDebugEnabled()) {
                        AbstractWebSocketScheduler.this._logger.debug("Processing queue, batch size {}: {}", (Object)batchSize, (Object)queue);
                    }
                    AbstractWebSocketScheduler.this.send(wsSession, queue, batchSize, (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                Flusher flusher2 = this;
                synchronized (flusher2) {
                    this._entries.poll();
                }
                entry.scheduleExpiration();
                if (AbstractWebSocketScheduler.this._logger.isDebugEnabled()) {
                    AbstractWebSocketScheduler.this._logger.debug("Processing replies {}", (Object)replies);
                }
                for (ServerMessage.Mutable reply2 : replies) {
                    AbstractWebSocketTransport.this.getBayeux().freeze(reply2);
                }
                AbstractWebSocketScheduler.this.send(wsSession, replies, replies.size(), (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onCompleteFailure(Throwable x) {
                org.cometd.websocket.server.common.AbstractWebSocketTransport$AbstractWebSocketScheduler.Entry entry;
                Flusher flusher = this;
                synchronized (flusher) {
                    this.terminated = true;
                    entry = this.entry;
                }
                if (entry != null) {
                    ((Entry)entry).scheduleExpiration();
                }
            }
        }

        private class MetaConnectReplyTask
        implements Runnable {
            private final ServerMessage.Mutable _connectReply;
            private final long _connectExpiration;

            private MetaConnectReplyTask(ServerMessage.Mutable connectReply, long connectExpiration) {
                this._connectReply = connectReply;
                this._connectExpiration = connectExpiration;
            }

            @Override
            public void run() {
                long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                long delay = now - this._connectExpiration;
                if (AbstractWebSocketScheduler.this._logger.isDebugEnabled() && delay > 5000L) {
                    AbstractWebSocketScheduler.this._logger.debug("/meta/connect {} expired {} ms too late", (Object)this._connectReply, (Object)delay);
                }
                AbstractWebSocketScheduler.this.schedule(true, this._connectReply);
            }
        }
    }
}

