/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server.common;

import java.util.ArrayList;
import java.util.List;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.websocket.server.common.AbstractWebSocketEndPoint;

public abstract class AbstractWebSocketTransport
extends AbstractServerTransport {
    public static final String NAME = "websocket";
    public static final String PREFIX = "ws";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String MESSAGES_PER_FRAME_OPTION = "messagesPerFrame";
    public static final String BUFFER_SIZE_OPTION = "bufferSize";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String COMETD_URL_MAPPING_OPTION = "cometdURLMapping";
    public static final String REQUIRE_HANDSHAKE_PER_CONNECTION_OPTION = "requireHandshakePerConnection";
    public static final String ENABLE_EXTENSION_PREFIX_OPTION = "enableExtension.";
    private String _protocol;
    private int _messagesPerFrame;
    private boolean _requireHandshakePerConnection;

    protected AbstractWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    public void init() {
        super.init();
        this._protocol = this.getOption(PROTOCOL_OPTION, null);
        this._messagesPerFrame = this.getOption(MESSAGES_PER_FRAME_OPTION, 1);
        this._requireHandshakePerConnection = this.getOption(REQUIRE_HANDSHAKE_PER_CONNECTION_OPTION, false);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public int getMessagesPerFrame() {
        return this._messagesPerFrame;
    }

    public boolean isRequireHandshakePerConnection() {
        return this._requireHandshakePerConnection;
    }

    protected List<String> normalizeURLMapping(String urlMapping) {
        String[] mappings = urlMapping.split(",");
        ArrayList<String> result = new ArrayList<String>(mappings.length);
        for (String mapping : mappings) {
            if (mapping.endsWith("/*")) {
                mapping = mapping.substring(0, mapping.length() - 2);
            }
            if (!mapping.startsWith("/")) {
                mapping = "/" + mapping;
            }
            result.add(mapping);
        }
        return result;
    }

    protected void onClose(int code, String reason) {
    }

    protected String toJSON(ServerMessage message) {
        return super.toJSON(message);
    }

    protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
    }
}

