/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server;

import java.io.IOException;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.websocket.server.AbstractWebSocketTransport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.LifeCycle;

public class WebSocketTransport
extends AbstractWebSocketTransport<Session> {
    public static final String BATCH_WRITES_OPTION = "batchWrites";
    private boolean _batchWrites;

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        ServerContainer container;
        super.init();
        ServletContext context = (ServletContext)this.getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        if (cometdURLMapping.endsWith("/*")) {
            cometdURLMapping = cometdURLMapping.substring(0, cometdURLMapping.length() - 2);
        }
        if ((container = (ServerContainer)context.getAttribute(ServerContainer.class.getName())) == null) {
            throw new IllegalArgumentException("Missing WebSocket ServerContainer");
        }
        int maxMessageSize = this.getOption("maxMessageSize", container.getDefaultMaxTextMessageBufferSize());
        container.setDefaultMaxTextMessageBufferSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", container.getDefaultMaxSessionIdleTimeout());
        container.setDefaultMaxSessionIdleTimeout(idleTimeout);
        this._batchWrites = this.getOption(BATCH_WRITES_OPTION, true);
        String protocol = this.getProtocol();
        ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketScheduler.class, (String)cometdURLMapping).subprotocols(protocol == null ? null : Collections.singletonList(protocol)).configurator((ServerEndpointConfig.Configurator)new Configurator(context)).build();
        try {
            container.addEndpoint(config);
        }
        catch (DeploymentException x) {
            throw new RuntimeException(x);
        }
    }

    public void destroy() {
        Executor threadPool = this.getExecutor();
        if (threadPool instanceof LifeCycle) {
            try {
                ((LifeCycle)threadPool).stop();
            }
            catch (Exception x) {
                this._logger.trace("", (Throwable)x);
            }
        }
        super.destroy();
    }

    protected boolean checkOrigin(String origin) {
        return true;
    }

    protected void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }

    protected void send(final Session wsSession, final ServerSession session, String data, final Callback callback) {
        this._logger.debug("Sending {}", (Object)data);
        wsSession.getAsyncRemote().sendText(data, new SendHandler(){

            public void onResult(SendResult result) {
                Throwable failure = result.getException();
                if (failure == null) {
                    callback.succeeded();
                } else {
                    WebSocketTransport.this.handleException(wsSession, session, failure);
                    callback.failed(failure);
                }
            }
        });
    }

    private class Configurator
    extends ServerEndpointConfig.Configurator {
        private final ServletContext servletContext;
        private WebSocketContext bayeuxContext;
        private boolean protocolMatches;

        private Configurator(ServletContext servletContext) {
            this.servletContext = servletContext;
            this.protocolMatches = true;
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            this.bayeuxContext = new WebSocketContext(this.servletContext, request);
            WebSocketTransport.this.modifyHandshake(request, response);
        }

        public boolean checkOrigin(String originHeaderValue) {
            return WebSocketTransport.this.checkOrigin(originHeaderValue);
        }

        public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
            this.protocolMatches = WebSocketTransport.this.checkProtocol(supported, requested);
            if (this.protocolMatches) {
                return super.getNegotiatedSubprotocol(supported, requested);
            }
            WebSocketTransport.this._logger.warn("Could not negotiate WebSocket SubProtocols: server{} != client{}", supported, requested);
            return null;
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
            return super.getNegotiatedExtensions(installed, requested);
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            if (!WebSocketTransport.this.getBayeux().getAllowedTransports().contains(WebSocketTransport.this.getName())) {
                throw new InstantiationException("Transport not allowed");
            }
            if (!this.protocolMatches) {
                throw new InstantiationException("Could not negotiate WebSocket SubProtocols");
            }
            return (T)((Object)new WebSocketScheduler(this.bayeuxContext));
        }
    }

    private class WebSocketContext
    implements BayeuxContext {
        private final ServletContext context;
        private final String url;
        private final Principal principal;
        private final Map<String, List<String>> headers;
        private final Map<String, List<String>> parameters;
        private final HttpSession session;

        private WebSocketContext(ServletContext context, HandshakeRequest request) {
            this.context = context;
            String uri = request.getRequestURI().toString();
            String query = request.getQueryString();
            if (query != null) {
                uri = uri + "?" + query;
            }
            this.url = uri;
            this.principal = request.getUserPrincipal();
            this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(request.getHeaders());
            this.parameters = request.getParameterMap();
            this.session = (HttpSession)request.getHttpSession();
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return null;
        }

        public InetSocketAddress getLocalAddress() {
            return null;
        }

        public String getHeader(String name) {
            List<String> values = this.headers.get(name);
            return values != null && values.size() > 0 ? values.get(0) : null;
        }

        public List<String> getHeaderValues(String name) {
            return this.headers.get(name);
        }

        public String getParameter(String name) {
            List<String> values = this.parameters.get(name);
            return values != null && values.size() > 0 ? values.get(0) : null;
        }

        public List<String> getParameterValues(String name) {
            return this.parameters.get(name);
        }

        public String getCookie(String name) {
            List<String> values = this.headers.get("Cookie");
            if (values != null) {
                for (String value : values) {
                    for (HttpCookie cookie : HttpCookie.parse(value)) {
                        if (!cookie.getName().equals(name)) continue;
                        return cookie.getValue();
                    }
                }
            }
            return null;
        }

        public String getHttpSessionId() {
            return this.session == null ? null : this.session.getId();
        }

        public Object getHttpSessionAttribute(String name) {
            return this.session == null ? null : this.session.getAttribute(name);
        }

        public void setHttpSessionAttribute(String name, Object value) {
            if (this.session != null) {
                this.session.setAttribute(name, value);
            }
        }

        public void invalidateHttpSession() {
            if (this.session != null) {
                this.session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return null;
        }

        public Object getContextAttribute(String name) {
            return this.context.getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this.context.getInitParameter(name);
        }

        public String getURL() {
            return this.url;
        }
    }

    private class WebSocketScheduler
    extends Endpoint
    implements AbstractServerTransport.Scheduler,
    MessageHandler.Whole<String> {
        private final AbstractWebSocketTransport.AbstractWebSocketScheduler delegate;
        private volatile Session _wsSession;

        private WebSocketScheduler(WebSocketContext context) {
            this.delegate = new AbstractWebSocketTransport.AbstractWebSocketScheduler(context){

                protected void send(Session wsSession, ServerSessionImpl session, boolean startInterval, List<ServerMessage> queue, List<ServerMessage> replies) {
                    super.send((Object)wsSession, session, startInterval, queue, replies);
                    this.flushBatchedWrites(wsSession, session);
                }

                private void flushBatchedWrites(Session wsSession, ServerSessionImpl session) {
                    try {
                        if (WebSocketTransport.this._batchWrites) {
                            this._logger.debug("Flushing batched messages for {}", (Object)session);
                            wsSession.getAsyncRemote().flushBatch();
                        }
                    }
                    catch (IOException x) {
                        this.close(1011, x.toString());
                        WebSocketTransport.this.handleException(wsSession, (ServerSession)session, x);
                    }
                }

                protected void close(int code, String reason) {
                    try {
                        WebSocketScheduler.this._wsSession.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
                    }
                    catch (IOException x) {
                        this._logger.trace("Could not close WebSocket session " + WebSocketScheduler.this._wsSession, (Throwable)x);
                    }
                }

                protected void schedule(boolean timeout, ServerMessage.Mutable expiredConnectReply) {
                    this.schedule(WebSocketScheduler.this._wsSession, timeout, expiredConnectReply);
                }
            };
        }

        public void onOpen(Session wsSession, EndpointConfig config) {
            this._wsSession = wsSession;
            wsSession.addMessageHandler((MessageHandler)this);
            this.configureBatchWrites(wsSession);
        }

        private void configureBatchWrites(Session wsSession) {
            try {
                wsSession.getAsyncRemote().setBatchingAllowed(WebSocketTransport.this._batchWrites);
            }
            catch (IOException x) {
                WebSocketTransport.this._logger.debug("Could not configure batch writes", (Throwable)x);
            }
        }

        public void onClose(Session wsSession, CloseReason closeReason) {
            this.delegate.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        }

        public void onError(Session wsSession, Throwable failure) {
            this.delegate.onError(failure);
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public void schedule() {
            this.delegate.schedule();
        }

        public void onMessage(String data) {
            WebSocketTransport.this._logger.debug("WebSocket Text message on {}/{}", (Object)((Object)((Object)WebSocketTransport.this)).hashCode(), (Object)((Object)((Object)this)).hashCode());
            this.delegate.onMessage((Object)this._wsSession, data);
        }
    }
}

