/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.websocket.server.AbstractBayeuxContext;
import org.cometd.websocket.server.AbstractWebSocketTransport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.LifeCycle;

public class WebSocketTransport
extends AbstractWebSocketTransport<Session> {
    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        ServletContext context = (ServletContext)this.getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        ServerContainer container = (ServerContainer)context.getAttribute(ServerContainer.class.getName());
        if (container == null) {
            throw new IllegalArgumentException("Missing WebSocket ServerContainer");
        }
        int maxMessageSize = this.getOption("maxMessageSize", container.getDefaultMaxTextMessageBufferSize());
        container.setDefaultMaxTextMessageBufferSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", container.getDefaultMaxSessionIdleTimeout());
        container.setDefaultMaxSessionIdleTimeout(idleTimeout);
        String protocol = this.getProtocol();
        List<String> protocols = protocol == null ? null : Collections.singletonList(protocol);
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketScheduler.class, (String)mapping).subprotocols(protocols).configurator((ServerEndpointConfig.Configurator)new Configurator(context)).build();
            try {
                container.addEndpoint(config);
            }
            catch (DeploymentException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public void destroy() {
        Executor threadPool = this.getExecutor();
        if (threadPool instanceof LifeCycle) {
            try {
                ((LifeCycle)threadPool).stop();
            }
            catch (Exception x) {
                this._logger.trace("", (Throwable)x);
            }
        }
        super.destroy();
    }

    protected boolean checkOrigin(String origin) {
        return true;
    }

    protected void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }

    protected void send(final Session wsSession, final ServerSession session, String data, final Callback callback) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Sending {}", (Object)data);
        }
        wsSession.getAsyncRemote().sendText(data, new SendHandler(){

            public void onResult(SendResult result) {
                Throwable failure = result.getException();
                if (failure == null) {
                    callback.succeeded();
                } else {
                    WebSocketTransport.this.handleException(wsSession, session, failure);
                    callback.failed(failure);
                }
            }
        });
    }

    private class Configurator
    extends ServerEndpointConfig.Configurator {
        private final ServletContext servletContext;
        private WebSocketContext bayeuxContext;
        private boolean protocolMatches;

        private Configurator(ServletContext servletContext) {
            this.servletContext = servletContext;
            this.protocolMatches = true;
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            this.bayeuxContext = new WebSocketContext(this.servletContext, request, sec.getUserProperties());
            WebSocketTransport.this.modifyHandshake(request, response);
        }

        public boolean checkOrigin(String originHeaderValue) {
            return WebSocketTransport.this.checkOrigin(originHeaderValue);
        }

        public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
            this.protocolMatches = WebSocketTransport.this.checkProtocol(supported, requested);
            if (this.protocolMatches) {
                return super.getNegotiatedSubprotocol(supported, requested);
            }
            WebSocketTransport.this._logger.warn("Could not negotiate WebSocket SubProtocols: server{} != client{}", supported, requested);
            return null;
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
            return super.getNegotiatedExtensions(installed, requested);
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            if (!WebSocketTransport.this.getBayeux().getAllowedTransports().contains(WebSocketTransport.this.getName())) {
                throw new InstantiationException("Transport not allowed");
            }
            if (!this.protocolMatches) {
                throw new InstantiationException("Could not negotiate WebSocket SubProtocols");
            }
            return (T)((Object)new WebSocketScheduler(this.bayeuxContext));
        }
    }

    private class WebSocketContext
    extends AbstractBayeuxContext {
        private WebSocketContext(ServletContext context, HandshakeRequest request, Map<String, Object> userProperties) {
            super(context, request.getRequestURI().toString(), request.getQueryString(), request.getHeaders(), request.getParameterMap(), request.getUserPrincipal(), (HttpSession)request.getHttpSession(), (InetSocketAddress)userProperties.get("javax.websocket.endpoint.localAddress"), (InetSocketAddress)userProperties.get("javax.websocket.endpoint.remoteAddress"));
        }
    }

    private class WebSocketScheduler
    extends Endpoint
    implements AbstractServerTransport.Scheduler,
    MessageHandler.Whole<String> {
        private final AbstractWebSocketTransport.AbstractWebSocketScheduler delegate;
        private volatile Session _wsSession;

        private WebSocketScheduler(WebSocketContext context) {
            this.delegate = new AbstractWebSocketTransport.AbstractWebSocketScheduler((BayeuxContext)context){

                protected void close(int code, String reason) {
                    try {
                        WebSocketScheduler.this._wsSession.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
                    }
                    catch (IOException x) {
                        this._logger.trace("Could not close WebSocket session " + WebSocketScheduler.this._wsSession, (Throwable)x);
                    }
                }

                protected void schedule(boolean timeout, ServerMessage.Mutable expiredConnectReply) {
                    this.schedule(WebSocketScheduler.this._wsSession, timeout, expiredConnectReply);
                }
            };
        }

        public void onOpen(Session wsSession, EndpointConfig config) {
            this._wsSession = wsSession;
            wsSession.addMessageHandler((MessageHandler)this);
        }

        public void onClose(Session wsSession, CloseReason closeReason) {
            this.delegate.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        }

        public void onError(Session wsSession, Throwable failure) {
            this.delegate.onError(failure);
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public void schedule() {
            this.delegate.schedule();
        }

        public void onMessage(String data) {
            if (WebSocketTransport.this._logger.isDebugEnabled()) {
                WebSocketTransport.this._logger.debug("WebSocket Text message on {}/{}", (Object)((Object)((Object)WebSocketTransport.this)).hashCode(), (Object)((Object)((Object)this)).hashCode());
            }
            this.delegate.onMessage((Object)this._wsSession, data);
        }
    }
}

