/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.UnresolvedAddressException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.TransportException;
import org.cometd.websocket.client.common.AbstractWebSocketTransport;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport
implements UpgradeListener {
    private final WebSocketClient _webSocketClient;
    private boolean _webSocketSupported;
    private boolean _webSocketConnected;

    public JettyWebSocketTransport(Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketClient webSocketClient) {
        this(null, options, scheduler, webSocketClient);
    }

    public JettyWebSocketTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketClient webSocketClient) {
        super(url, options, scheduler);
        this._webSocketClient = webSocketClient;
        this._webSocketSupported = true;
    }

    public boolean accept(String version) {
        return this._webSocketSupported;
    }

    public void init() {
        super.init();
        this._webSocketClient.setConnectTimeout(this.getConnectTimeout());
        this._webSocketClient.setCookieStore(this.getCookieStore());
        this._webSocketClient.getPolicy().setIdleTimeout(this.getIdleTimeout());
        int maxMessageSize = this.getOption("maxMessageSize", this._webSocketClient.getPolicy().getMaxTextMessageSize());
        this._webSocketClient.getPolicy().setMaxTextMessageSize(maxMessageSize);
        this._webSocketSupported = true;
        this._webSocketConnected = false;
    }

    protected AbstractWebSocketTransport.Delegate connect(String uri, TransportListener listener, List<Message.Mutable> messages) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Opening websocket session to {}", (Object)uri);
            }
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            String protocol = this.getProtocol();
            if (protocol != null) {
                request.setSubProtocols(new String[]{protocol});
            }
            AbstractWebSocketTransport.Delegate delegate = this.connect(this._webSocketClient, request, uri);
            this._webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException | SocketTimeoutException | UnresolvedAddressException x) {
            listener.onFailure((Throwable)x, messages);
        }
        catch (UpgradeException x) {
            this._webSocketSupported = false;
            HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
            failure.put("websocketCode", 1002);
            failure.put("httpCode", x.getResponseStatusCode());
            listener.onFailure((Throwable)new TransportException((Throwable)x, failure), messages);
        }
        catch (Throwable x) {
            this._webSocketSupported = this.isStickyReconnect() && this._webSocketConnected;
            listener.onFailure(x, messages);
        }
        return null;
    }

    protected AbstractWebSocketTransport.Delegate connect(WebSocketClient client, ClientUpgradeRequest request, String uri) throws IOException, InterruptedException {
        try {
            AbstractWebSocketTransport.Delegate delegate = this.newDelegate();
            long timeout = this.getConnectTimeout() + 1000L;
            client.connect((Object)delegate, new URI(uri), request, (UpgradeListener)this).get(timeout, TimeUnit.MILLISECONDS);
            return delegate;
        }
        catch (TimeoutException e) {
            throw new ConnectException("Connect timeout");
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (URISyntaxException x) {
            throw new IOException(x);
        }
    }

    protected AbstractWebSocketTransport.Delegate newDelegate() {
        return new JettyWebSocketDelegate();
    }

    public void onHandshakeRequest(UpgradeRequest request) {
    }

    public void onHandshakeResponse(UpgradeResponse response) {
        this.storeCookies(response.getHeaders());
    }

    protected class JettyWebSocketDelegate
    extends AbstractWebSocketTransport.Delegate
    implements WebSocketListener {
        private Session _session;

        protected JettyWebSocketDelegate() {
            super((AbstractWebSocketTransport)JettyWebSocketTransport.this);
        }

        public void onWebSocketConnect(Session session) {
            JettyWebSocketTransport.this.locked(() -> {
                this._session = session;
                return this._session;
            });
            if (JettyWebSocketTransport.this.logger.isDebugEnabled()) {
                JettyWebSocketTransport.this.logger.debug("Opened websocket session {}", (Object)session);
            }
        }

        public void onWebSocketClose(int closeCode, String reason) {
            this.onClose(closeCode, reason);
        }

        public void onWebSocketText(String data) {
            this.onData(data);
        }

        public void onWebSocketBinary(byte[] payload, int offset, int len) {
        }

        public void onWebSocketError(Throwable failure) {
            this.failMessages(failure);
        }

        public void send(String content) {
            Session session = (Session)JettyWebSocketTransport.this.locked(() -> this._session);
            try {
                if (session == null) {
                    throw new IOException("Unconnected");
                }
                long timeout = JettyWebSocketTransport.this.getIdleTimeout() + 1000L;
                session.getRemote().sendStringByFuture(content).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException x) {
                this.fail(x, "Timeout");
            }
            catch (ExecutionException x) {
                this.fail(x.getCause(), "Exception");
            }
            catch (Throwable x) {
                this.fail(x, "Failure");
            }
        }

        protected void shutdown(String reason) {
            Session session = (Session)JettyWebSocketTransport.this.locked(() -> {
                Session result = this._session;
                this.close();
                return result;
            });
            if (session != null) {
                if (JettyWebSocketTransport.this.logger.isDebugEnabled()) {
                    JettyWebSocketTransport.this.logger.debug("Closing websocket session {}", (Object)session);
                }
                session.close(1000, reason);
            }
        }

        protected boolean isOpen() {
            return (Boolean)JettyWebSocketTransport.this.locked(() -> super.isOpen() && this._session != null);
        }

        protected void close() {
            JettyWebSocketTransport.this.locked(() -> {
                this._session = null;
                return null;
            });
        }
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final WebSocketClient wsClient;

        public Factory(WebSocketClient wsClient) {
            this.wsClient = wsClient;
            this.addBean(wsClient);
        }

        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)options.get("scheduler");
            return new JettyWebSocketTransport(url, options, scheduler, this.wsClient);
        }
    }
}

