/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.websocket.server.common.AbstractBayeuxContext;
import org.cometd.websocket.server.common.AbstractWebSocketTransport;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport<Session> {
    public JettyWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        final ServletContext context = (ServletContext)this.getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        NativeWebSocketConfiguration wsConfig = (NativeWebSocketConfiguration)context.getAttribute(NativeWebSocketConfiguration.class.getName());
        if (wsConfig == null) {
            throw new IllegalArgumentException("Missing WebSocketConfiguration");
        }
        WebSocketPolicy policy = wsConfig.getFactory().getPolicy();
        int bufferSize = this.getOption("bufferSize", policy.getInputBufferSize());
        policy.setInputBufferSize(bufferSize);
        int maxMessageSize = this.getOption("maxMessageSize", policy.getMaxTextMessageSize());
        policy.setMaxTextMessageSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", policy.getIdleTimeout());
        policy.setIdleTimeout((long)((int)idleTimeout));
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            wsConfig.addMapping((PathSpec)new ServletPathSpec(mapping), new WebSocketCreator(){

                public Object createWebSocket(ServletUpgradeRequest request, ServletUpgradeResponse response) {
                    String origin = request.getHeader("Origin");
                    if (origin == null) {
                        origin = request.getHeader("Sec-WebSocket-Origin");
                    }
                    if (JettyWebSocketTransport.this.checkOrigin(request, origin)) {
                        ArrayList<ExtensionConfig> negotiated = new ArrayList<ExtensionConfig>();
                        for (ExtensionConfig extensionConfig : request.getExtensions()) {
                            String name = extensionConfig.getName();
                            boolean option = JettyWebSocketTransport.this.getOption("enableExtension." + name, true);
                            if (!option) continue;
                            negotiated.add(extensionConfig);
                        }
                        response.setExtensions(negotiated);
                        JettyWebSocketTransport.this.modifyUpgrade(request, response);
                        List allowedTransports = JettyWebSocketTransport.this.getBayeux().getAllowedTransports();
                        if (allowedTransports.contains(JettyWebSocketTransport.this.getName())) {
                            WebSocketContext handshake = new WebSocketContext(context, request);
                            return new WebSocketScheduler(handshake);
                        }
                        if (JettyWebSocketTransport.this._logger.isDebugEnabled()) {
                            JettyWebSocketTransport.this._logger.debug("Transport not those allowed: {}", (Object)allowedTransports);
                        }
                    } else if (JettyWebSocketTransport.this._logger.isDebugEnabled()) {
                        JettyWebSocketTransport.this._logger.debug("Origin check failed for origin {}", (Object)origin);
                    }
                    return null;
                }
            });
        }
    }

    protected void modifyUpgrade(ServletUpgradeRequest request, ServletUpgradeResponse response) {
    }

    protected boolean checkOrigin(ServletUpgradeRequest request, String origin) {
        return true;
    }

    protected void send(final Session wsSession, final ServerSession session, String data, final Callback callback) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Sending {}", (Object)data);
        }
        wsSession.getRemote().sendString(data, new WriteCallback(){

            public void writeSuccess() {
                callback.succeeded();
            }

            public void writeFailed(Throwable x) {
                JettyWebSocketTransport.this.handleException(wsSession, session, x);
                callback.failed(x);
            }
        });
    }

    private class WebSocketContext
    extends AbstractBayeuxContext {
        private final Map<String, Object> attributes;

        private WebSocketContext(ServletContext context, ServletUpgradeRequest request) {
            super(context, request.getRequestURI().toString(), request.getQueryString(), request.getHeaders(), request.getParameterMap(), request.getUserPrincipal(), request.getSession(), request.getLocalSocketAddress(), request.getRemoteSocketAddress(), Collections.list(request.getLocales()));
            this.attributes = request.getServletAttributes();
        }

        public Object getRequestAttribute(String name) {
            return this.attributes.get(name);
        }
    }

    private class WebSocketScheduler
    extends AbstractWebSocketTransport.AbstractWebSocketScheduler
    implements WebSocketListener {
        private volatile Session _wsSession;

        private WebSocketScheduler(WebSocketContext context) {
            super((AbstractWebSocketTransport)JettyWebSocketTransport.this, (BayeuxContext)context);
        }

        public void onWebSocketConnect(Session session) {
            this._wsSession = session;
        }

        public void onWebSocketBinary(byte[] payload, int offset, int len) {
        }

        public void onWebSocketText(String data) {
            this.onMessage(this._wsSession, data);
        }

        public void onWebSocketClose(int code, String reason) {
            this.onClose(code, reason);
        }

        public void onWebSocketError(Throwable failure) {
            this.onError(failure);
        }

        protected void close(int code, String reason) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Closing {}/{}", (Object)code, (Object)reason);
            }
            this._wsSession.close(code, reason);
        }

        protected void schedule(boolean timeout, ServerMessage.Mutable expiredConnectReply) {
            this.schedule(this._wsSession, timeout, expiredConnectReply);
        }
    }
}

