/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.client.okhttp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.websocket.client.common.AbstractWebSocketTransport;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class OkHttpWebsocketTransport
extends AbstractWebSocketTransport {
    private static final String SEC_WEB_SOCKET_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    private static final String SEC_WEB_SOCKET_ACCEPT_HEADER = "Sec-WebSocket-Accept";
    private final OkHttpClient okHttpClient;
    private boolean webSocketSupported;
    private boolean webSocketConnected;

    public OkHttpWebsocketTransport(Map<String, Object> options, OkHttpClient okHttpClient) {
        this(null, options, null, okHttpClient);
    }

    public OkHttpWebsocketTransport(String uri, Map<String, Object> options, ScheduledExecutorService scheduler, OkHttpClient okHttpClient) {
        super(uri, options, scheduler);
        OkHttpClient.Builder enrichedClient = okHttpClient.newBuilder().connectTimeout(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        if (okHttpClient.pingIntervalMillis() == 0) {
            enrichedClient.pingInterval(20L, TimeUnit.SECONDS);
        }
        this.okHttpClient = enrichedClient.build();
        this.webSocketSupported = true;
    }

    public void init() {
        super.init();
        this.webSocketSupported = true;
        this.webSocketConnected = false;
    }

    public boolean accept(String s) {
        return this.webSocketSupported;
    }

    protected AbstractWebSocketTransport.Delegate connect(String uri, TransportListener listener, List<Message.Mutable> messages) {
        try {
            CompletableFuture connectCompletable = new CompletableFuture();
            OkHttpDelegate delegate = new OkHttpDelegate(connectCompletable);
            Request upgradeRequest = this.buildUpgradeRequest(uri);
            this.okHttpClient.newWebSocket(upgradeRequest, delegate.listener);
            Throwable connectFailure = (Throwable)connectCompletable.get(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (connectFailure != null) {
                throw connectFailure;
            }
            this.webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException | SocketTimeoutException | UnresolvedAddressException | TimeoutException e) {
            listener.onFailure((Throwable)e, messages);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            listener.onFailure((Throwable)e, messages);
        }
        catch (Throwable e) {
            this.webSocketSupported = this.isStickyReconnect() && this.webSocketConnected;
            listener.onFailure(e, messages);
        }
        return null;
    }

    private Request buildUpgradeRequest(String uri) {
        String protocol = this.getProtocol();
        Request.Builder upgradeRequest = new Request.Builder().url(uri);
        if (protocol != null && !protocol.isEmpty()) {
            upgradeRequest.header(SEC_WEB_SOCKET_PROTOCOL_HEADER, protocol);
        }
        CookieStore cookieStore = this.getCookieStore();
        List<HttpCookie> cookies = cookieStore.get(URI.create(uri));
        for (HttpCookie cookie : cookies) {
            String cookieValue = cookie.getName() + "=" + cookie.getValue();
            upgradeRequest.addHeader("Cookie", cookieValue);
        }
        return upgradeRequest.build();
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final OkHttpClient okHttpClient;

        public Factory(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            this.addBean(okHttpClient);
        }

        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)options.get("scheduler");
            return new OkHttpWebsocketTransport(url, options, scheduler, this.okHttpClient);
        }
    }

    private class OkHttpDelegate
    extends AbstractWebSocketTransport.Delegate {
        private final WebSocketListener listener;
        private final CompletableFuture<Throwable> connectCompletable;
        private WebSocket webSocket;

        private OkHttpDelegate(CompletableFuture<Throwable> connectCompletable) {
            super((AbstractWebSocketTransport)OkHttpWebsocketTransport.this);
            this.listener = new OkHttpListener();
            this.connectCompletable = connectCompletable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onOpen(WebSocket webSocket, Response response) {
            OkHttpDelegate okHttpDelegate = this;
            synchronized (okHttpDelegate) {
                this.webSocket = webSocket;
            }
            OkHttpWebsocketTransport.this.webSocketSupported = response.header(OkHttpWebsocketTransport.SEC_WEB_SOCKET_ACCEPT_HEADER) != null;
            OkHttpWebsocketTransport.this.storeCookies(response.headers().toMultimap());
            if (OkHttpWebsocketTransport.this.logger.isDebugEnabled()) {
                OkHttpWebsocketTransport.this.logger.debug("Opened {}", (Object)webSocket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void send(String payload) {
            WebSocket webSocket;
            OkHttpDelegate okHttpDelegate = this;
            synchronized (okHttpDelegate) {
                webSocket = this.webSocket;
            }
            try {
                if (webSocket == null) {
                    throw new IOException("Unconnected!");
                }
                boolean enqueued = webSocket.send(payload);
                if (!enqueued) {
                    throw new IOException("Not enqueued! Current queue size: " + webSocket.queueSize());
                }
            }
            catch (Throwable throwable) {
                OkHttpWebsocketTransport.this.logger.warn("Failure sending " + payload, throwable);
                this.fail(throwable, "Exception");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isOpen() {
            OkHttpDelegate okHttpDelegate = this;
            synchronized (okHttpDelegate) {
                return this.webSocket != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            OkHttpDelegate okHttpDelegate = this;
            synchronized (okHttpDelegate) {
                this.webSocket = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown(String reason) {
            WebSocket webSocket;
            OkHttpDelegate okHttpDelegate = this;
            synchronized (okHttpDelegate) {
                webSocket = this.webSocket;
                this.close();
            }
            if (webSocket != null) {
                int code = 1000;
                if (OkHttpWebsocketTransport.this.logger.isDebugEnabled()) {
                    OkHttpWebsocketTransport.this.logger.debug("Closing websocket {}/{}", (Object)code, (Object)reason);
                }
                try {
                    reason = this.trimCloseReason(reason);
                    webSocket.close(code, reason);
                }
                catch (Throwable t) {
                    OkHttpWebsocketTransport.this.logger.warn(String.format("Unable to close websocket %d/%s", code, reason), t);
                }
            }
        }

        private final class OkHttpListener
        extends WebSocketListener {
            private OkHttpListener() {
            }

            public void onOpen(WebSocket webSocket, Response response) {
                OkHttpDelegate.this.onOpen(webSocket, response);
                OkHttpDelegate.this.connectCompletable.complete(null);
            }

            public void onMessage(WebSocket webSocket, String text) {
                OkHttpDelegate.this.onData(text);
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                OkHttpDelegate.this.onClose(code, reason);
            }

            public void onFailure(WebSocket webSocket, Throwable failure, Response response) {
                if (!OkHttpDelegate.this.connectCompletable.complete(failure)) {
                    OkHttpDelegate.this.failMessages(failure);
                }
            }
        }
    }
}

