/*
 * Decompiled with CFR 0.152.
 */
package org.cometd;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.ScriptableObject;

public class HttpCookieStore
extends ScriptableObject {
    private Map<String, Map<String, Cookie>> allCookies = new HashMap<String, Map<String, Cookie>>();

    public String getClassName() {
        return "HttpCookieStore";
    }

    public String jsFunction_get(String scheme, String host, String path) throws Exception {
        try {
            Map<String, Cookie> cookies = this.allCookies.get(host + path);
            if (cookies == null) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            long now = System.currentTimeMillis();
            for (Cookie cookie : cookies.values()) {
                if (cookie.expires != null && cookie.expires < now) continue;
                if (buffer.length() > 0) {
                    buffer.append(";");
                }
                buffer.append(cookie.name).append("=").append(cookie.value);
            }
            return buffer.toString();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw x;
        }
    }

    public void jsFunction_set(String scheme, String host, String path, String value) throws Exception {
        try {
            String[] parts;
            Cookie cookie = new Cookie();
            for (String part : parts = value.split(";")) {
                if ("secure".equalsIgnoreCase(part = part.trim())) {
                    cookie.secure = true;
                    continue;
                }
                String[] pair = part.split("=", 2);
                String key = pair[0].trim();
                String val = pair[1].trim();
                if ("expires".equalsIgnoreCase(key)) {
                    if (cookie.expires != null) continue;
                    cookie.expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US).parse(val).getTime();
                    continue;
                }
                if ("max-age".equalsIgnoreCase(key)) {
                    cookie.expires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(Integer.parseInt(val));
                    continue;
                }
                if ("path".equalsIgnoreCase(key)) {
                    cookie.path = val;
                    continue;
                }
                if ("domain".equalsIgnoreCase(key)) {
                    cookie.domain = val;
                    continue;
                }
                if ("comment".equalsIgnoreCase(key) || "commenturl".equalsIgnoreCase(key) || "discard".equalsIgnoreCase(key) || "port".equalsIgnoreCase(key) || "version".equalsIgnoreCase(key)) continue;
                cookie.name = key;
                cookie.value = val;
                String cookieKey = host + path;
                Map<String, Cookie> cookies = this.allCookies.get(cookieKey);
                if (val.length() == 0) {
                    if (cookies == null) continue;
                    cookies.remove(key);
                    if (cookies.size() != 0) continue;
                    this.allCookies.remove(cookieKey);
                    continue;
                }
                if (cookies == null) {
                    cookies = new HashMap<String, Cookie>();
                    this.allCookies.put(cookieKey, cookies);
                }
                cookies.put(key, cookie);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw x;
        }
    }

    public void clear() {
        this.allCookies.clear();
    }

    public void putAll(HttpCookieStore other) {
        this.allCookies.putAll(other.allCookies);
    }

    private static class Cookie {
        private String name;
        private String value;
        private boolean secure;
        private String domain;
        private String path;
        private Long expires;

        private Cookie() {
        }
    }
}

