/*
 * Decompiled with CFR 0.152.
 */
package org.cometd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.cometd.ThreadModel;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class XMLHttpRequestExchange
extends ScriptableObject {
    private CometExchange exchange;

    public void jsConstructor(Object threadModel, Scriptable scope, Scriptable thiz, Function function, String method, String url) {
        this.exchange = new CometExchange((ThreadModel)threadModel, scope, thiz, function, method, url);
    }

    public String getClassName() {
        return "XMLHttpRequestExchange";
    }

    public HttpExchange getHttpExchange() {
        return this.exchange;
    }

    public void jsFunction_addRequestHeader(String name, String value) {
        this.exchange.addRequestHeader(name, value);
    }

    public String jsGet_method() {
        return this.exchange.getMethod();
    }

    public void jsFunction_setRequestContent(String data) throws UnsupportedEncodingException {
        this.exchange.setRequestContent(data);
    }

    public int jsGet_readyState() {
        return this.exchange.getReadyState();
    }

    public String jsGet_responseText() {
        return this.exchange.getResponseText();
    }

    public int jsGet_responseStatus() {
        return this.exchange.getResponseStatus();
    }

    public String jsGet_responseStatusText() {
        return this.exchange.getResponseStatusText();
    }

    public void jsFunction_cancel() {
        this.exchange.cancel();
    }

    public String jsFunction_getAllResponseHeaders() {
        return this.exchange.getAllResponseHeaders();
    }

    public String jsFunction_getResponseHeader(String name) {
        return this.exchange.getResponseHeader(name);
    }

    public static class CometExchange
    extends ContentExchange {
        private final ThreadModel threads;
        private final Scriptable scope;
        private final Scriptable thiz;
        private final Function function;
        private final HttpFields responseFields = new HttpFields();
        private volatile boolean aborted;
        private volatile ReadyState readyState = ReadyState.UNSENT;
        private volatile String responseText;
        private volatile String responseStatusText;

        public CometExchange(ThreadModel threads, Scriptable scope, Scriptable thiz, Function function, String method, String url) {
            this.threads = threads;
            this.scope = scope;
            this.thiz = thiz;
            this.function = function;
            this.setMethod(method == null ? "GET" : method.toUpperCase());
            this.setURL(url);
            this.aborted = false;
            this.readyState = ReadyState.OPENED;
            this.responseStatusText = null;
            this.getRequestFields().clear();
            this.notifyReadyStateChange();
        }

        private void notifyReadyStateChange() {
            this.threads.execute(this.scope, this.thiz, this.function, new Object[0]);
        }

        public void cancel() {
            super.cancel();
            this.aborted = true;
            this.responseText = null;
            this.getRequestFields().clear();
            if (this.readyState == ReadyState.HEADERS_RECEIVED || this.readyState == ReadyState.LOADING) {
                this.readyState = ReadyState.DONE;
                this.notifyReadyStateChange();
            }
            this.readyState = ReadyState.UNSENT;
        }

        public int getReadyState() {
            return this.readyState.ordinal();
        }

        public String getResponseText() {
            return this.responseText;
        }

        public String getResponseStatusText() {
            return this.responseStatusText;
        }

        public void setRequestContent(String content) throws UnsupportedEncodingException {
            this.setRequestContent((Buffer)new ByteArrayBuffer(content, "UTF-8"));
        }

        public String getAllResponseHeaders() {
            return this.responseFields.toString();
        }

        public String getResponseHeader(String name) {
            return this.responseFields.getStringField(name);
        }

        protected void onResponseStatus(Buffer version, int status, Buffer statusText) throws IOException {
            super.onResponseStatus(version, status, statusText);
            this.responseStatusText = new String(statusText.asArray(), "UTF-8");
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            this.responseFields.add(name, value);
            super.onResponseHeader(name, value);
        }

        protected void onResponseHeaderComplete() throws IOException {
            super.onResponseHeaderComplete();
            if (!this.aborted) {
                this.readyState = ReadyState.HEADERS_RECEIVED;
                this.notifyReadyStateChange();
            }
        }

        protected void onResponseContent(Buffer buffer) throws IOException {
            super.onResponseContent(buffer);
            if (!this.aborted && this.readyState != ReadyState.LOADING) {
                this.readyState = ReadyState.LOADING;
                this.notifyReadyStateChange();
            }
        }

        protected void onResponseComplete() throws IOException {
            super.onResponseComplete();
            if (!this.aborted) {
                this.responseText = this.getResponseContent();
                this.readyState = ReadyState.DONE;
                this.notifyReadyStateChange();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ReadyState {
            UNSENT,
            OPENED,
            HEADERS_RECEIVED,
            LOADING,
            DONE;

        }
    }
}

