/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.servlet.Servlet;
import junit.framework.TestCase;
import org.cometd.javascript.HttpCookieStore;
import org.cometd.javascript.JavaScriptThreadModel;
import org.cometd.javascript.ThreadModel;
import org.cometd.javascript.XMLHttpRequestClient;
import org.cometd.javascript.XMLHttpRequestExchange;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.continuation.ContinuationCometdServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCometdTest
extends TestCase {
    private HttpCookieStore cookies;
    private Server server;
    protected int longPollingPeriod = 5000;
    protected String cometServletPath = "/cometd";
    protected int port;
    protected String contextURL;
    protected String cometdURL;
    protected int expirationPeriod = 2500;
    private ThreadModel threadModel;
    private XMLHttpRequestClient xhrClient;

    protected void setUp() throws Exception {
        this.cookies = new HttpCookieStore();
        this.initCometServer();
    }

    public void initCometServer() throws Exception {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        this.server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        this.server.setHandler((Handler)handlers);
        String contextPath = "/cometd";
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)handlers, contextPath, 1);
        context.addServlet(DefaultServlet.class, "/");
        ContinuationCometdServlet cometServlet = new ContinuationCometdServlet();
        ServletHolder cometServletHolder = new ServletHolder((Servlet)cometServlet);
        cometServletHolder.setInitParameter("timeout", String.valueOf(this.longPollingPeriod));
        cometServletHolder.setInitParameter("logLevel", "2");
        cometServletHolder.setInitParameter("requestAvailable", "true");
        cometServletHolder.setInitParameter("maxInterval", String.valueOf(this.expirationPeriod));
        context.addServlet(cometServletHolder, this.cometServletPath + "/*");
        this.customizeContext(context);
        this.server.start();
        this.port = connector.getLocalPort();
        this.contextURL = "http://localhost:" + this.port + contextPath;
        this.cometdURL = this.contextURL + this.cometServletPath;
        this.customizeBayeux(cometServlet.getBayeux());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initJavaScript() throws Exception {
        Context jsContext = Context.enter();
        try {
            ScriptableObject rootScope = jsContext.initStandardObjects();
            ScriptableObject.defineClass((Scriptable)rootScope, HttpCookieStore.class);
            jsContext.evaluateString((Scriptable)rootScope, "var cookies = new HttpCookieStore();", "cookies", 1, null);
            HttpCookieStore cookies = (HttpCookieStore)((Object)rootScope.get("cookies", (Scriptable)rootScope));
            cookies.putAll(this.cookies);
            this.cookies = cookies;
            ScriptableObject.defineClass((Scriptable)rootScope, JavaScriptThreadModel.class);
            jsContext.evaluateString((Scriptable)rootScope, "var threadModel = new JavaScriptThreadModel(this);", "threadModel", 1, null);
            this.threadModel = (ThreadModel)rootScope.get("threadModel", (Scriptable)rootScope);
            this.threadModel.init();
            ScriptableObject.defineClass((Scriptable)rootScope, XMLHttpRequestClient.class);
            ScriptableObject.defineClass((Scriptable)rootScope, XMLHttpRequestExchange.class);
            jsContext.evaluateString((Scriptable)rootScope, "var xhrClient = new XMLHttpRequestClient(2);", "xhrClient", 1, null);
            this.xhrClient = (XMLHttpRequestClient)((Object)rootScope.get("xhrClient", (Scriptable)rootScope));
            this.xhrClient.start();
        }
        finally {
            Context.exit();
        }
    }

    protected void tearDown() throws Exception {
        this.destroyCometServer();
        this.cookies.clear();
    }

    public void destroyJavaScript() throws Exception {
        this.threadModel.destroy();
        this.xhrClient.stop();
    }

    public void destroyCometServer() throws Exception {
        this.server.stop();
        this.server.join();
    }

    protected abstract void customizeContext(ServletContextHandler var1) throws Exception;

    protected void customizeBayeux(AbstractBayeux bayeux) {
    }

    protected void evaluateURL(URL script) throws IOException {
        this.threadModel.evaluate(script);
    }

    protected <T> T evaluateScript(String script) {
        return this.evaluateScript(null, script);
    }

    protected <T> T evaluateScript(String scriptName, String script) {
        return (T)this.threadModel.evaluate(scriptName, script);
    }

    protected void defineClass(Class clazz) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        this.threadModel.define(clazz);
    }

    protected <T> T get(String name) {
        return (T)this.threadModel.get(name);
    }
}

