/*
 * Decompiled with CFR 0.152.
 */
package org.cometd;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import junit.framework.TestCase;
import org.cometd.HttpCookieStore;
import org.cometd.JavaScriptThreadModel;
import org.cometd.ThreadModel;
import org.cometd.XMLHttpRequestClient;
import org.cometd.XMLHttpRequestExchange;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometdServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class AbstractCometdTest
extends TestCase {
    private ThreadModel threadModel;
    private Server server;
    protected int port;
    protected String contextURL;
    protected String cometServletPath = "/cometd";
    protected String cometdURL;
    protected int longPollingPeriod = 5000;
    private HttpCookieStore cookies;

    protected void setUp() throws Exception {
        this.cookies = new HttpCookieStore();
        this.initCometServer();
    }

    public void initCometServer() throws Exception {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        this.server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        this.server.setHandler((Handler)handlers);
        String contextPath = "/cometd";
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)handlers, contextPath, 1);
        context.addServlet(DefaultServlet.class, "/");
        CometdServlet cometServlet = new CometdServlet();
        ServletHolder cometServletHolder = new ServletHolder((Servlet)cometServlet);
        cometServletHolder.setInitParameter("timeout", String.valueOf(this.longPollingPeriod));
        cometServletHolder.setInitParameter("logLevel", "2");
        context.addServlet(cometServletHolder, this.cometServletPath + "/*");
        context.addEventListener((EventListener)((Object)new BayeuxInitializer()));
        this.customizeContext(context);
        this.server.start();
        this.port = connector.getLocalPort();
        this.contextURL = "http://localhost:" + this.port + contextPath;
        this.cometdURL = this.contextURL + this.cometServletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initJavaScript() throws Exception {
        Context jsContext = Context.enter();
        try {
            ScriptableObject rootScope = jsContext.initStandardObjects();
            ScriptableObject.defineClass((Scriptable)rootScope, HttpCookieStore.class);
            jsContext.evaluateString((Scriptable)rootScope, "var cookies = new HttpCookieStore();", "cookies", 1, null);
            HttpCookieStore cookies = (HttpCookieStore)((Object)rootScope.get("cookies", (Scriptable)rootScope));
            cookies.putAll(this.cookies);
            this.cookies = cookies;
            ScriptableObject.defineClass((Scriptable)rootScope, JavaScriptThreadModel.class);
            jsContext.evaluateString((Scriptable)rootScope, "var threadModel = new JavaScriptThreadModel(this);", "threadModel", 1, null);
            this.threadModel = (ThreadModel)rootScope.get("threadModel", (Scriptable)rootScope);
            this.threadModel.init();
        }
        finally {
            Context.exit();
        }
        this.threadModel.evaluate("var maxConnections = " + this.getMaxConnections() + ";");
        this.threadModel.define(XMLHttpRequestClient.class);
        this.threadModel.define(XMLHttpRequestExchange.class);
    }

    protected int getMaxConnections() {
        return 2;
    }

    protected void tearDown() throws Exception {
        this.destroyCometServer();
        this.cookies.clear();
    }

    public void destroyJavaScript() throws Exception {
        this.threadModel.destroy();
    }

    public void destroyCometServer() throws Exception {
        this.server.stop();
        this.server.join();
    }

    protected abstract void customizeContext(ServletContextHandler var1) throws Exception;

    protected void customizeBayeux(BayeuxServerImpl bayeux) {
    }

    protected void evaluateURL(URL script) throws IOException {
        this.threadModel.evaluate(script);
    }

    protected <T> T evaluateScript(String script) {
        return (T)this.threadModel.evaluate(script);
    }

    protected void defineClass(Class clazz) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        this.threadModel.define(clazz);
    }

    protected <T> T get(String name) {
        return (T)this.threadModel.get(name);
    }

    public static Object jsToJava(Object jsObject) {
        if (jsObject == null) {
            return null;
        }
        if (jsObject == Context.getUndefinedValue()) {
            return null;
        }
        if (jsObject instanceof String) {
            return jsObject;
        }
        if (jsObject instanceof Boolean) {
            return jsObject;
        }
        if (jsObject instanceof Integer) {
            return jsObject;
        }
        if (jsObject instanceof Long) {
            return jsObject;
        }
        if (jsObject instanceof Float) {
            return jsObject;
        }
        if (jsObject instanceof Double) {
            return jsObject;
        }
        if (jsObject instanceof NativeArray) {
            return AbstractCometdTest.convertArray((NativeArray)jsObject);
        }
        if (jsObject instanceof NativeObject) {
            return AbstractCometdTest.convertObject((NativeObject)jsObject);
        }
        if (jsObject instanceof NativeJavaObject) {
            return ((NativeJavaObject)jsObject).unwrap();
        }
        return jsObject;
    }

    private static Object[] convertArray(NativeArray jsArray) {
        Object[] ids = jsArray.getIds();
        Object[] result = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            int index = (Integer)id;
            Object jsValue = jsArray.get(index, (Scriptable)jsArray);
            result[i] = AbstractCometdTest.jsToJava(jsValue);
        }
        return result;
    }

    private static Object convertObject(NativeObject jsObject) {
        Object[] ids = jsObject.getIds();
        HashMap<Object, Object> result = new HashMap<Object, Object>(ids.length);
        for (Object id : ids) {
            Object jsValue;
            if (id instanceof String) {
                jsValue = jsObject.get((String)id, (Scriptable)jsObject);
                result.put(id, AbstractCometdTest.jsToJava(jsValue));
                continue;
            }
            if (id instanceof Integer) {
                jsValue = jsObject.get(((Integer)id).intValue(), (Scriptable)jsObject);
                result.put(id, AbstractCometdTest.jsToJava(jsValue));
                continue;
            }
            throw new AssertionError();
        }
        return result;
    }

    private class BayeuxInitializer
    implements ServletContextAttributeListener {
        private BayeuxInitializer() {
        }

        public void attributeAdded(ServletContextAttributeEvent event) {
            if (event.getName().equals("org.cometd.bayeux")) {
                BayeuxServerImpl bayeux = (BayeuxServerImpl)event.getValue();
                AbstractCometdTest.this.customizeBayeux(bayeux);
            }
        }

        public void attributeRemoved(ServletContextAttributeEvent event) {
        }

        public void attributeReplaced(ServletContextAttributeEvent event) {
        }
    }
}

