/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.javascript.ThreadModel;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptThreadModel
extends ScriptableObject
implements Runnable,
ThreadModel {
    private final Thread thread = new Thread(this);
    private final BlockingQueue<FutureTask<Object>> queue = new LinkedBlockingQueue<FutureTask<Object>>();
    private final ScriptableObject rootScope;
    private volatile boolean running;
    private volatile Context context;
    private AtomicInteger scripts = new AtomicInteger();

    public JavaScriptThreadModel() {
        this(null);
    }

    public JavaScriptThreadModel(ScriptableObject rootScope) {
        this.rootScope = rootScope;
    }

    @Override
    public void init() throws Exception {
        assert (this.rootScope != null);
        this.queue.clear();
        this.running = true;
        this.thread.start();
    }

    @Override
    public void destroy() throws Exception {
        this.running = false;
        for (FutureTask futureTask : this.queue) {
            futureTask.cancel(false);
        }
        this.thread.interrupt();
        this.thread.join();
    }

    public String getClassName() {
        return "JavaScriptThreadModel";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.context = Context.enter();
        this.context.setGeneratingDebug(true);
        this.context.setGeneratingSource(true);
        this.context.setOptimizationLevel(-1);
        try {
            while (this.running) {
                FutureTask<Object> command = this.queue.take();
                command.run();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Context.exit();
            this.context = null;
        }
    }

    @Override
    public Object evaluate(final URL url) throws IOException {
        FutureTask<Object> future = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                return JavaScriptThreadModel.this.context.evaluateReader((Scriptable)JavaScriptThreadModel.this.rootScope, (Reader)new InputStreamReader(url.openStream()), url.toExternalForm(), 1, null);
            }
        });
        this.submit(future);
        try {
            return future.get();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException x) {
            Throwable xx = x.getCause();
            if (xx instanceof IOException) {
                throw (IOException)xx;
            }
            if (xx instanceof Error) {
                throw (Error)xx;
            }
            throw (RuntimeException)xx;
        }
    }

    @Override
    public Object evaluate(final String scriptName, final String script) {
        FutureTask<Object> future = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() {
                return JavaScriptThreadModel.this.context.evaluateString((Scriptable)JavaScriptThreadModel.this.rootScope, script, scriptName == null ? JavaScriptThreadModel.this.nextScriptName() : scriptName, 1, null);
            }
        });
        this.submit(future);
        try {
            return future.get();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException x) {
            Throwable xx = x.getCause();
            if (xx instanceof Error) {
                throw (Error)xx;
            }
            throw (RuntimeException)xx;
        }
    }

    private String nextScriptName() {
        return "script_" + this.scripts.incrementAndGet();
    }

    public Object jsFunction_invoke(Scriptable scope, Scriptable thiz, Function function) {
        return this.invoke(true, scope, thiz, function, new Object[0]);
    }

    @Override
    public Object invoke(boolean sync, final Scriptable scope, final Scriptable thiz, final Function function, final Object ... arguments) {
        Callable<Object> invocation = new Callable<Object>(){

            @Override
            public Object call() {
                return function.call(JavaScriptThreadModel.this.context, scope, thiz, arguments);
            }
        };
        return this.invoke(true, invocation);
    }

    @Override
    public Object invoke(boolean sync, final Scriptable scope, final Scriptable thiz, final String functionName, final Object ... arguments) {
        Callable<Object> invocation = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Function function = (Function)ScriptableObject.getProperty((Scriptable)thiz, (String)functionName);
                return function.call(JavaScriptThreadModel.this.context, scope, thiz, arguments);
            }
        };
        return this.invoke(sync, invocation);
    }

    private Object invoke(boolean sync, Callable<Object> invocation) {
        FutureTask<Object> future = new FutureTask<Object>(invocation);
        this.submit(future);
        if (!sync) {
            return null;
        }
        try {
            return future.get();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException x) {
            Throwable xx = x.getCause();
            if (xx instanceof Error) {
                throw (Error)xx;
            }
            throw (RuntimeException)xx;
        }
    }

    private void submit(FutureTask<Object> future) {
        if (Thread.currentThread() == this.thread) {
            future.run();
        } else if (this.running) {
            this.queue.offer(future);
        } else {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public void define(final Class clazz) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        FutureTask<Object> future = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws InvocationTargetException, IllegalAccessException, InstantiationException {
                ScriptableObject.defineClass((Scriptable)JavaScriptThreadModel.this.rootScope, (Class)clazz);
                return null;
            }
        });
        this.submit(future);
        try {
            future.get();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException x) {
            Throwable xx = x.getCause();
            if (xx instanceof InvocationTargetException) {
                throw (InvocationTargetException)xx;
            }
            if (xx instanceof IllegalAccessException) {
                throw (IllegalAccessException)xx;
            }
            if (xx instanceof InstantiationException) {
                throw (InstantiationException)xx;
            }
            if (xx instanceof Error) {
                throw (Error)xx;
            }
            throw (RuntimeException)xx;
        }
    }

    @Override
    public Object get(final String name) {
        FutureTask<Object> future = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() {
                return JavaScriptThreadModel.this.rootScope.get(name, (Scriptable)JavaScriptThreadModel.this.rootScope);
            }
        });
        this.submit(future);
        try {
            Object result = future.get();
            if (Context.getUndefinedValue().equals(result)) {
                return null;
            }
            if (Scriptable.NOT_FOUND.equals(result)) {
                throw new IllegalArgumentException("No object named " + name + " exists in scope");
            }
            return result;
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException x) {
            Throwable xx = x.getCause();
            if (xx instanceof Error) {
                throw (Error)xx;
            }
            throw (RuntimeException)xx;
        }
    }
}

