/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeoutException;
import org.cometd.javascript.HttpCookieStore;
import org.cometd.javascript.ThreadModel;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLHttpRequestExchange
extends ScriptableObject {
    private CometDExchange exchange;

    public void jsConstructor(Object cookieStore, Object threadModel, Scriptable thiz, String method, String url, boolean async) {
        this.exchange = new CometDExchange((HttpCookieStore)((Object)cookieStore), (ThreadModel)threadModel, thiz, method, url, async);
    }

    public String getClassName() {
        return "XMLHttpRequestExchange";
    }

    public HttpExchange getHttpExchange() {
        return this.exchange;
    }

    public boolean isAsynchronous() {
        return this.exchange.isAsynchronous();
    }

    public void await() throws Exception {
        if (this.exchange.waitForDone() == 7) {
            this.exchange.notifyReadyStateChange(false);
        } else {
            this.exchange.rethrow();
        }
    }

    public void jsFunction_addRequestHeader(String name, String value) {
        this.exchange.addRequestHeader(name, value);
    }

    public String jsGet_method() {
        return this.exchange.getMethod();
    }

    public void jsFunction_setRequestContent(String data) throws UnsupportedEncodingException {
        this.exchange.setRequestContent(data);
    }

    public int jsGet_readyState() {
        return this.exchange.getReadyState();
    }

    public String jsGet_responseText() {
        return this.exchange.getResponseText();
    }

    public int jsGet_responseStatus() {
        return this.exchange.getResponseStatus();
    }

    public String jsGet_responseStatusText() {
        return this.exchange.getResponseStatusText();
    }

    public void jsFunction_abort() {
        this.exchange.cancel();
    }

    public String jsFunction_getAllResponseHeaders() {
        return this.exchange.getAllResponseHeaders();
    }

    public String jsFunction_getResponseHeader(String name) {
        return this.exchange.getResponseHeader(name);
    }

    public void send(HttpClient httpClient) throws Exception {
        this.exchange.send(httpClient);
    }

    public static class CometDExchange
    extends ContentExchange {
        private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
        private final HttpCookieStore cookieStore;
        private final ThreadModel threads;
        private final Scriptable thiz;
        private final boolean async;
        private volatile boolean aborted;
        private volatile ReadyState readyState = ReadyState.UNSENT;
        private volatile String responseText;
        private volatile String responseStatusText;
        private volatile Throwable failure;

        public CometDExchange(HttpCookieStore cookieStore, ThreadModel threads, Scriptable thiz, String method, String url, boolean async) {
            super(true);
            this.cookieStore = cookieStore;
            this.threads = threads;
            this.thiz = thiz;
            this.setMethod(method == null ? "GET" : method.toUpperCase());
            this.setURL(url);
            this.async = async;
            this.aborted = false;
            this.readyState = ReadyState.OPENED;
            this.responseStatusText = null;
            this.getRequestFields().clear();
            if (async) {
                this.notifyReadyStateChange(false);
            }
        }

        public boolean isAsynchronous() {
            return this.async;
        }

        private void notifyReadyStateChange(boolean sync) {
            this.threads.invoke(sync, this.thiz, this.thiz, "onreadystatechange", new Object[0]);
        }

        public void send(HttpClient httpClient) throws Exception {
            String cookies = this.cookieStore.jsFunction_get(this.getScheme().toString("UTF-8"), this.getAddress().toString(), "");
            if (cookies.length() > 0) {
                this.setRequestHeader("Cookie", cookies);
            }
            this.log("Submitted {}", new Object[]{this});
            httpClient.send((HttpExchange)this);
        }

        public void cancel() {
            super.cancel();
            this.log("Aborted {}", new Object[]{this});
            this.aborted = true;
            this.responseText = null;
            this.getRequestFields().clear();
            if (!this.async || this.readyState == ReadyState.HEADERS_RECEIVED || this.readyState == ReadyState.LOADING) {
                this.readyState = ReadyState.DONE;
                this.notifyReadyStateChange(false);
            }
            this.readyState = ReadyState.UNSENT;
        }

        public int getReadyState() {
            return this.readyState.ordinal();
        }

        public String getResponseText() {
            return this.responseText;
        }

        public String getResponseStatusText() {
            return this.responseStatusText;
        }

        public void setRequestContent(String content) throws UnsupportedEncodingException {
            this.setRequestContent((Buffer)new ByteArrayBuffer(content, "UTF-8"));
        }

        public String getAllResponseHeaders() {
            return this.getResponseFields().toString();
        }

        public String getResponseHeader(String name) {
            return this.getResponseFields().getStringField(name);
        }

        protected void onResponseStatus(Buffer version, int status, Buffer statusText) throws IOException {
            super.onResponseStatus(version, status, statusText);
            this.responseStatusText = new String(statusText.asArray(), "UTF-8");
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            super.onResponseHeader(name, value);
            int headerName = HttpHeaders.CACHE.getOrdinal(name);
            if (headerName == 53) {
                try {
                    this.cookieStore.jsFunction_set(this.getScheme().toString("UTF-8"), this.getAddress().toString(), "", value.toString("UTF-8"));
                }
                catch (Exception x) {
                    throw (IOException)new IOException().initCause(x);
                }
            }
        }

        protected void onResponseHeaderComplete() throws IOException {
            if (!this.aborted && this.async) {
                this.readyState = ReadyState.HEADERS_RECEIVED;
                this.notifyReadyStateChange(true);
            }
        }

        protected void onResponseContent(Buffer buffer) throws IOException {
            super.onResponseContent(buffer);
            if (!this.aborted && this.async && this.readyState != ReadyState.LOADING) {
                this.readyState = ReadyState.LOADING;
                this.notifyReadyStateChange(true);
            }
        }

        protected void onResponseComplete() throws IOException {
            if (!this.aborted) {
                this.log("Completed ({}) {}", new Object[]{this.getResponseStatus(), this});
                this.responseText = this.getResponseContent();
                this.readyState = ReadyState.DONE;
                if (this.async) {
                    this.notifyReadyStateChange(true);
                }
            }
        }

        protected void onConnectionFailed(Throwable x) {
            super.onConnectionFailed(x);
            this.fail(x);
        }

        protected void onException(Throwable x) {
            if (!(x instanceof EOFException)) {
                super.onException(x);
            }
            this.fail(x);
        }

        protected void onExpire() {
            super.onExpire();
            this.fail(new TimeoutException());
        }

        private void fail(Throwable x) {
            this.failure = x;
            this.log("Failed: {}", x);
            if (this.async) {
                this.readyState = ReadyState.DONE;
                this.notifyReadyStateChange(true);
            }
        }

        public void rethrow() throws Exception {
            if (this.failure instanceof Exception) {
                throw (Exception)this.failure;
            }
            if (this.failure instanceof Error) {
                throw (Error)this.failure;
            }
        }

        protected void onRequestCommitted() throws IOException {
            super.onRequestCommitted();
            this.log("Committed {}", new Object[]{this});
        }

        protected void onRequestComplete() throws IOException {
            super.onRequestComplete();
            this.log("Sent {}", new Object[]{this});
        }

        private void log(String message, Object ... args) {
            if (Boolean.getBoolean("debugTests")) {
                this.logger.info(message, args);
            } else {
                this.logger.debug(message, args);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ReadyState {
            UNSENT,
            OPENED,
            HEADERS_RECEIVED,
            LOADING,
            DONE;

        }
    }
}

