/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.IOException;
import java.net.URI;
import org.cometd.javascript.HttpCookieStore;
import org.cometd.javascript.ThreadModel;
import org.cometd.javascript.WebSocketClientFactory;
import org.eclipse.jetty.websocket.WebSocket;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
extends ScriptableObject
implements WebSocket.OnTextMessage {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private ThreadModel threads;
    private Scriptable thiz;
    private WebSocket.FrameConnection connection;

    public WebSocketClient() {
    }

    public WebSocketClient(Object cookieStore, Object threadModel, Scriptable thiz, Object factory, String url, Object protocol) {
        this.threads = (ThreadModel)threadModel;
        this.thiz = thiz;
        try {
            WebSocketClientFactory wsFactory = (WebSocketClientFactory)((Object)factory);
            org.eclipse.jetty.websocket.WebSocketClient wsClient = wsFactory.newWebSocketClient();
            if (protocol != null && protocol != Undefined.instance) {
                wsClient.setProtocol(protocol.toString());
            }
            URI uri = new URI(url);
            wsClient.getCookies().putAll(((HttpCookieStore)((Object)cookieStore)).getAll(uri));
            this.log("Opening WebSocket connection to {}", uri);
            wsClient.open(uri, (WebSocket)this);
        }
        catch (Exception x) {
            this.onError(x);
        }
    }

    public String getClassName() {
        return "WebSocketClient";
    }

    public void jsFunction_send(String data) throws IOException {
        if (this.connection != null) {
            this.log("WebSocket sending data {}", data);
            this.connection.sendMessage(data);
        }
    }

    public void jsFunction_close(int code, String reason) {
        if (this.connection != null) {
            this.connection.close(code, reason);
            this.connection = null;
        }
    }

    public void onOpen(WebSocket.Connection connection) {
        this.connection = (WebSocket.FrameConnection)connection;
        this.log("WebSocket opened connection {}", connection);
        this.threads.invoke(false, this.thiz, this.thiz, "onopen", new Object[0]);
    }

    public void onMessage(String data) {
        this.log("WebSocket message data {}", data);
        Object event = this.threads.evaluate("event", "({data:'" + data + "'})");
        this.threads.invoke(false, this.thiz, this.thiz, "onmessage", event);
    }

    public void onClose(int closeCode, String reason) {
        this.log("WebSocket closed with code {}/{}", closeCode, reason);
        Object event = this.threads.evaluate("event", "({code:" + closeCode + ",reason:'" + reason + "'})");
        this.threads.invoke(false, this.thiz, this.thiz, "onclose", event);
    }

    public void onError(Throwable x) {
        this.log("WebSocket error {}", x);
        this.threads.invoke(false, this.thiz, this.thiz, "onerror", new Object[0]);
    }

    private void log(String message, Object ... args) {
        if (Boolean.getBoolean("debugTests")) {
            this.logger.info(message, args);
        } else {
            this.logger.debug(message, args);
        }
    }
}

