/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class Utils {
    private Utils() {
    }

    public static Object jsToJava(Object jsObject) {
        return Utils.jsToJava(jsObject, new IdentityHashMap<Object, Boolean>());
    }

    private static Object jsToJava(Object jsObject, Map<Object, Boolean> identities) {
        Boolean existing = identities.put(jsObject, Boolean.TRUE);
        if (existing != null) {
            return jsObject;
        }
        if (jsObject == null) {
            return null;
        }
        if (jsObject == Context.getUndefinedValue()) {
            return null;
        }
        if (jsObject instanceof String) {
            return jsObject;
        }
        if (jsObject instanceof Boolean) {
            return jsObject;
        }
        if (jsObject instanceof Integer) {
            return jsObject;
        }
        if (jsObject instanceof Long) {
            return jsObject;
        }
        if (jsObject instanceof Float) {
            return jsObject;
        }
        if (jsObject instanceof Double) {
            return jsObject;
        }
        if (jsObject instanceof NativeArray) {
            return Utils.convertArray((NativeArray)jsObject, identities);
        }
        if (jsObject instanceof NativeObject) {
            return Utils.convertObject((NativeObject)jsObject, identities);
        }
        if (jsObject instanceof NativeJavaObject) {
            return ((NativeJavaObject)jsObject).unwrap();
        }
        return jsObject;
    }

    private static Object[] convertArray(NativeArray jsArray, Map<Object, Boolean> identities) {
        Object[] ids = jsArray.getIds();
        Object[] result = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            int index = (Integer)id;
            Object jsValue = jsArray.get(index, (Scriptable)jsArray);
            result[i] = Utils.jsToJava(jsValue, identities);
        }
        return result;
    }

    private static Object convertObject(NativeObject jsObject, Map<Object, Boolean> identities) {
        Object[] ids = jsObject.getIds();
        HashMap<Object, Object> result = new HashMap<Object, Object>(ids.length);
        for (Object id : ids) {
            Object jsValue;
            if (id instanceof String) {
                jsValue = jsObject.get((String)id, (Scriptable)jsObject);
                result.put(id, Utils.jsToJava(jsValue, identities));
                continue;
            }
            if (id instanceof Integer) {
                jsValue = jsObject.get(((Integer)id).intValue(), (Scriptable)jsObject);
                result.put(id, Utils.jsToJava(jsValue, identities));
                continue;
            }
            throw new AssertionError();
        }
        return result;
    }

    public static boolean isJavaScriptObject(Object object) {
        return object instanceof NativeObject;
    }
}

