/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.IOException;
import java.net.URI;
import org.cometd.javascript.ThreadModel;
import org.cometd.javascript.WebSocketConnector;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
extends ScriptableObject
implements WebSocketListener {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private ThreadModel threads;
    private Scriptable thiz;
    private WebSocketClient wsClient;
    private Session session;

    public void jsConstructor(Object threadModel, Scriptable thiz, Object connector, String url, Object protocol) {
        this.threads = (ThreadModel)threadModel;
        this.thiz = thiz;
        this.wsClient = ((WebSocketConnector)((Object)connector)).getWebSocketClient();
        try {
            URI uri = new URI(url);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            if (protocol != null && protocol != Undefined.instance) {
                request.setSubProtocols(new String[]{protocol.toString()});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Opening WebSocket session to {}", (Object)uri);
            }
            this.wsClient.connect((Object)this, uri, request);
        }
        catch (Throwable x) {
            this.wsClient.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    WebSocketConnection.this.onWebSocketError(x);
                }
            });
        }
    }

    public String getClassName() {
        return "WebSocketConnection";
    }

    public void jsFunction_send(String data) throws IOException {
        try {
            Session session = this.session;
            if (session != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("WebSocket sending data {}", (Object)data);
                }
                session.getRemote().sendString(data);
            }
        }
        catch (Throwable x) {
            this.wsClient.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    WebSocketConnection.this.onWebSocketError(x);
                }
            });
        }
    }

    public void jsFunction_close(int code, String reason) throws IOException {
        Session session = this.session;
        if (session != null) {
            session.close(code, reason);
            this.session = null;
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket opened session {}", (Object)session);
        }
        this.threads.invoke(false, this.thiz, this.thiz, "onopen", new Object[0]);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketText(String data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket message data {}", (Object)data);
        }
        Object event = this.threads.evaluate("event", "({data:'" + data + "'})");
        this.threads.invoke(false, this.thiz, this.thiz, "onmessage", event);
    }

    public void onWebSocketClose(int closeCode, String reason) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket closed with code {}/{}", (Object)closeCode, (Object)reason);
        }
        Object event = this.threads.evaluate("event", "({code:" + closeCode + ",reason:'" + reason + "'})");
        this.threads.invoke(false, this.thiz, this.thiz, "onclose", event);
    }

    public void onWebSocketError(Throwable x) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket exception", x);
        }
        this.threads.invoke(false, this.thiz, this.thiz, "onerror", new Object[0]);
    }
}

