/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.net.HttpCookie;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.HttpCookieStore;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptCookieStore
extends ScriptableObject {
    private Store store;

    public String getClassName() {
        return "JavaScriptCookieStore";
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public void clear() {
        this.store.clear();
    }

    public String jsFunction_get(String scheme, String host, String path) {
        try {
            URI uri = URI.create(scheme + "://" + host + path);
            List uriCookies = this.store.get(uri);
            StringBuilder buffer = new StringBuilder();
            if (uriCookies != null) {
                for (HttpCookie cookie : uriCookies) {
                    if (cookie.isHttpOnly() || cookie.hasExpired()) continue;
                    if (buffer.length() > 0) {
                        buffer.append(";");
                    }
                    buffer.append(cookie.getName()).append("=").append(cookie.getValue());
                }
            }
            return buffer.toString();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw x;
        }
    }

    public void jsFunction_set(String scheme, String host, String uriPath, String cookies) throws Exception {
        block11: {
            try {
                String[] parts;
                String name = null;
                String value = null;
                boolean secure = false;
                boolean httpOnly = false;
                String domain = null;
                String path = null;
                long maxAge = 0L;
                for (String part : parts = cookies.split(";")) {
                    if ("Secure".equalsIgnoreCase(part = part.trim())) {
                        secure = true;
                        continue;
                    }
                    if ("HttpOnly".equalsIgnoreCase(part)) {
                        httpOnly = true;
                        continue;
                    }
                    String[] pair = part.split("=", 2);
                    String key = pair[0].trim();
                    String val = pair[1].trim();
                    if ("Domain".equalsIgnoreCase(key)) {
                        domain = val;
                        continue;
                    }
                    if ("Path".equalsIgnoreCase(key)) {
                        path = val;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(key)) {
                        if (maxAge > 0L) continue;
                        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        maxAge = TimeUnit.MILLISECONDS.toSeconds(dateFormat.parse(val).getTime() - System.currentTimeMillis());
                        continue;
                    }
                    if ("Max-Age".equalsIgnoreCase(key)) {
                        maxAge = Integer.parseInt(val);
                        continue;
                    }
                    if ("Comment".equalsIgnoreCase(key) || "CommentURL".equalsIgnoreCase(key) || "Discard".equalsIgnoreCase(key) || "Port".equalsIgnoreCase(key) || "Version".equalsIgnoreCase(key)) continue;
                    name = key;
                    value = val;
                }
                URI uri = URI.create(scheme + "://" + host + uriPath);
                List uriCookies = this.store.get(uri);
                if (value == null || value.isEmpty()) {
                    if (uriCookies == null) break block11;
                    for (HttpCookie cookie : uriCookies) {
                        if (!cookie.getName().equals(name)) continue;
                        this.store.remove(uri, cookie);
                        break block11;
                    }
                    break block11;
                }
                HttpCookie cookie = new HttpCookie(name, value);
                cookie.setSecure(secure);
                cookie.setHttpOnly(httpOnly);
                cookie.setDomain(domain);
                cookie.setPath(path);
                cookie.setMaxAge(maxAge);
                this.store.add(uri, cookie);
            }
            catch (Exception x) {
                x.printStackTrace();
                throw x;
            }
        }
    }

    public static class Store
    extends HttpCookieStore {
        public boolean removeAll() {
            return false;
        }

        public void clear() {
            super.removeAll();
        }
    }
}

