/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.cometd.javascript.JavaScriptCookieStore;
import org.cometd.javascript.XMLHttpRequestClient;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class WebSocketConnector {
    private final XMLHttpRequestClient xhrClient;
    private final JavaScriptCookieStore cookieStore;
    private WebSocketClient wsClient;

    public WebSocketConnector(XMLHttpRequestClient xhrClient, JavaScriptCookieStore cookieStore) {
        this.xhrClient = xhrClient;
        this.cookieStore = cookieStore;
    }

    public void start() throws Exception {
        this.wsClient = new WebSocketClient(this.xhrClient.getHttpClient());
        this.wsClient.setExecutor((Executor)((Object)new PrivilegedExecutor()));
        this.wsClient.setCookieStore(this.cookieStore.getStore());
        this.wsClient.start();
    }

    public void stop() throws Exception {
        this.wsClient.stop();
    }

    public WebSocketClient getWebSocketClient() {
        return this.wsClient;
    }

    private class PrivilegedExecutor
    extends QueuedThreadPool {
        private final ThreadFactory factory = Executors.privilegedThreadFactory();

        public PrivilegedExecutor() {
            this.setName("wsclient");
        }

        protected Thread newThread(Runnable runnable) {
            return this.factory.newThread(runnable);
        }
    }
}

