/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.cometd.javascript.JavaScript;
import org.cometd.javascript.XMLHttpRequestClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLHttpRequestExchange {
    private final CometDExchange exchange;

    public XMLHttpRequestExchange(Object client, JavaScript javaScript, ScriptObjectMirror thiz, String method, String url, boolean async) {
        this.exchange = new CometDExchange((XMLHttpRequestClient)client, javaScript, thiz, method, url, async);
    }

    public void addRequestHeader(String name, String value) {
        this.exchange.getRequest().header(name, value);
    }

    public String getMethod() {
        return this.exchange.getRequest().getMethod();
    }

    public void setRequestContent(String data) throws UnsupportedEncodingException {
        this.exchange.setRequestContent(data);
    }

    public int getReadyState() {
        return this.exchange.getReadyState();
    }

    public String getResponseText() {
        return this.exchange.getResponseText();
    }

    public int getResponseStatus() {
        return this.exchange.getResponseStatus();
    }

    public String getResponseStatusText() {
        return this.exchange.getResponseStatusText();
    }

    public void abort() {
        this.exchange.abort();
    }

    public String getAllResponseHeaders() {
        return this.exchange.getAllResponseHeaders();
    }

    public String getResponseHeader(String name) {
        return this.exchange.getResponseHeader(name);
    }

    public void send() throws Exception {
        this.exchange.send();
        try {
            if (!this.exchange.isAsynchronous()) {
                this.exchange.get(60L, TimeUnit.SECONDS);
            }
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw (Error)cause;
        }
    }

    public static class CometDExchange
    extends FutureResponseListener {
        private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
        private final JavaScript javaScript;
        private final ScriptObjectMirror thiz;
        private final boolean async;
        private volatile boolean aborted;
        private volatile ReadyState readyState = ReadyState.UNSENT;
        private volatile String requestText;
        private volatile String responseText;
        private volatile int responseStatus;
        private volatile String responseStatusText;

        public CometDExchange(XMLHttpRequestClient client, JavaScript javaScript, ScriptObjectMirror thiz, String method, String url, boolean async) {
            super(client.getHttpClient().newRequest(url));
            this.getRequest().method(HttpMethod.fromString((String)method));
            this.javaScript = javaScript;
            this.thiz = thiz;
            this.async = async;
            this.aborted = false;
            this.readyState = ReadyState.OPENED;
            this.responseStatusText = null;
            if (async) {
                this.notifyReadyStateChange(false);
            }
        }

        public boolean isAsynchronous() {
            return this.async;
        }

        private void notifyReadyStateChange(boolean sync) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Notifying onreadystatechange ({}) {}", (Object)this.readyState, (Object)this.getRequest().getURI());
            }
            this.javaScript.invoke(sync, this.thiz, "onreadystatechange", new Object[0]);
        }

        private void notifyLoad() {
            this.javaScript.invoke(true, this.thiz, "onload", new Object[0]);
        }

        private void notifyError(boolean sync) {
            this.javaScript.invoke(sync, this.thiz, "onerror", new Object[0]);
        }

        public void send() throws Exception {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Submitted {}", (Object)this);
            }
            this.getRequest().send((Response.CompleteListener)this);
        }

        public void abort() {
            this.cancel(false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Aborted {}", (Object)this);
            }
            this.aborted = true;
            this.responseText = null;
            this.getRequest().getHeaders().clear();
            if (this.readyState == ReadyState.HEADERS_RECEIVED || this.readyState == ReadyState.LOADING) {
                this.readyState = ReadyState.DONE;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(false);
                    this.notifyError(false);
                }
            } else {
                this.readyState = ReadyState.UNSENT;
            }
        }

        public int getReadyState() {
            return this.readyState.ordinal();
        }

        public String getResponseText() {
            return this.responseText;
        }

        public int getResponseStatus() {
            return this.responseStatus;
        }

        public String getResponseStatusText() {
            return this.responseStatusText;
        }

        public void setRequestContent(String content) {
            this.requestText = content;
            this.getRequest().content((ContentProvider)new StringContentProvider(content));
        }

        public String getAllResponseHeaders() {
            return this.getRequest().getHeaders().toString();
        }

        public String getResponseHeader(String name) {
            return this.getRequest().getHeaders().get(name);
        }

        public void onBegin(Response response) {
            super.onBegin(response);
            this.responseStatus = response.getStatus();
            this.responseStatusText = response.getReason();
        }

        public void onHeaders(Response response) {
            super.onHeaders(response);
            if (!this.aborted) {
                this.readyState = ReadyState.HEADERS_RECEIVED;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(true);
                }
            }
        }

        public void onContent(Response response, ByteBuffer content) {
            super.onContent(response, content);
            if (!this.aborted && this.readyState != ReadyState.LOADING) {
                this.readyState = ReadyState.LOADING;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(true);
                }
            }
        }

        public void onComplete(Result result) {
            if (result.isSucceeded()) {
                Response response = result.getResponse();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Succeeded ({}) {}", (Object)response.getStatus(), (Object)this);
                }
                if (!this.aborted) {
                    this.responseText = this.getContentAsString();
                    this.readyState = ReadyState.DONE;
                    if (this.isAsynchronous()) {
                        this.notifyReadyStateChange(true);
                        this.notifyLoad();
                    }
                }
            } else {
                Throwable failure = result.getFailure();
                if (!(failure instanceof EOFException) && this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed " + (Object)((Object)this), failure);
                }
                this.readyState = ReadyState.DONE;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(true);
                    this.notifyError(true);
                }
            }
            super.onComplete(result);
        }

        public String toString() {
            if (this.requestText == null) {
                return String.format("%s(%s)", new Object[]{this.getRequest(), this.readyState});
            }
            return String.format("%s(%s)%n%s", new Object[]{this.getRequest(), this.readyState, this.requestText});
        }

        public static enum ReadyState {
            UNSENT,
            OPENED,
            HEADERS_RECEIVED,
            LOADING,
            DONE;

        }
    }
}

