/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.Reader;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.api.scripting.URLReader;
import org.cometd.javascript.JavaScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScript
implements Runnable {
    private static final ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<FutureTask<?>> queue = new LinkedBlockingQueue();
    private final Thread thread = new Thread((Runnable)this, "javascript");
    private final Bindings bindings = engine.createBindings();
    private volatile boolean running;

    public JavaScript() {
        this.bindings.put("javaScript", (Object)this);
    }

    public void init() {
        this.queue.clear();
        this.running = true;
        this.thread.start();
    }

    public void destroy() throws Exception {
        this.running = false;
        for (FutureTask futureTask : this.queue) {
            futureTask.cancel(false);
        }
        this.thread.interrupt();
        this.thread.join();
        this.bindings.clear();
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                FutureTask<?> task = this.queue.take();
                task.run();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public <T> T invoke(boolean sync, ScriptObjectMirror thiz, Object function, Object ... arguments) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            try {
                if (function instanceof ScriptObjectMirror) {
                    return ((ScriptObjectMirror)function).call((Object)thiz, arguments);
                }
                String name = function.toString();
                if (thiz.hasMember(name)) {
                    Object member = thiz.getMember(name);
                    if (member instanceof ScriptObjectMirror) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Invoking function {}", (Object)name);
                        }
                        return ((ScriptObjectMirror)member).call((Object)thiz, arguments);
                    }
                    this.logger.info("Function {} not defined in {}", (Object)name, (Object)thiz);
                    return null;
                }
                this.logger.info("Function {} not a member of {}", (Object)name, (Object)thiz);
                return null;
            }
            catch (Throwable x) {
                this.logger.info("Exception while trying to invoke " + function, x);
                throw x;
            }
        });
        this.submit(task);
        if (!sync) {
            return null;
        }
        return (T)this.result(task);
    }

    public <T> T evaluate(URL url) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            Object object;
            URLReader r = new URLReader(url);
            try {
                object = engine.eval((Reader)r, this.bindings);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ScriptException x) {
                    throw new JavaScriptException(x);
                }
            }
            r.close();
            return object;
        });
        return (T)this.submitTask(task);
    }

    public <T> T evaluate(String name, String code) {
        String script = name == null ? code : String.format("//# sourceURL=%s%n%s", name, code);
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            try {
                this.bindings.put("javax.script.filename", (Object)name);
                return engine.eval(script, this.bindings);
            }
            catch (ScriptException x) {
                throw new JavaScriptException(x);
            }
        });
        return (T)this.submitTask(task);
    }

    private <T> T submitTask(FutureTask<T> task) {
        this.submit(task);
        return this.result(task);
    }

    public <T> T get(String key) {
        FutureTask<Object> task = new FutureTask<Object>(() -> this.getAsync(key));
        this.submit(task);
        return (T)this.result(task);
    }

    public <T> T getAsync(String key) {
        return (T)this.bindings.get(key);
    }

    public void putAsync(String key, Object value) {
        this.bindings.put(key, value);
    }

    private void submit(FutureTask<?> task) {
        if (Thread.currentThread() == this.thread) {
            task.run();
        } else if (this.running) {
            this.queue.offer(task);
        } else {
            throw new RejectedExecutionException();
        }
    }

    private <T> T result(FutureTask<T> task) {
        try {
            return task.get();
        }
        catch (InterruptedException x) {
            return null;
        }
        catch (ExecutionException x) {
            Throwable xx = x.getCause();
            if (xx instanceof Error) {
                throw (Error)xx;
            }
            throw (RuntimeException)xx;
        }
    }
}

