/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class Latch {
    private final AtomicReference<CountDownLatch> latch = new AtomicReference();

    public Latch(int count) {
        this.reset(count);
    }

    public void reset(int count) {
        this.latch.set(new CountDownLatch(count));
    }

    public boolean await(long timeout) throws InterruptedException {
        return this.latch.get().await(timeout, TimeUnit.MILLISECONDS);
    }

    public void countDown() {
        this.latch.get().countDown();
    }

    public long getCount() {
        return this.latch.get().getCount();
    }
}

