/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.net.URI;
import org.cometd.javascript.JavaScript;
import org.cometd.javascript.WebSocketConnector;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
implements WebSocketListener {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private JavaScript javaScript;
    private Object jsWebSocket;
    private WebSocketClient wsClient;
    private Session session;

    public WebSocketConnection(JavaScript javaScript, Object jsWebSocket, Object connector, String url, String protocol) {
        this.javaScript = javaScript;
        this.jsWebSocket = jsWebSocket;
        this.wsClient = ((WebSocketConnector)connector).getWebSocketClient();
        try {
            URI uri = new URI(url);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            if (protocol != null) {
                request.setSubProtocols(new String[]{protocol});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Opening WebSocket session to {}", (Object)uri);
            }
            this.wsClient.connect((Object)this, uri, request);
        }
        catch (Throwable x) {
            this.wsClient.getExecutor().execute(() -> this.onWebSocketError(x));
        }
    }

    public void send(String data) {
        try {
            Session session = this.session;
            if (session != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("WebSocket sending data {}", (Object)data);
                }
                session.getRemote().sendString(data, null);
            }
        }
        catch (Throwable x) {
            this.wsClient.getExecutor().execute(() -> this.onWebSocketError(x));
        }
    }

    public void close(int code, String reason) {
        Session session = this.session;
        if (session != null) {
            session.close(code, reason);
            this.session = null;
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket opened session {}", (Object)session);
        }
        this.javaScript.invoke(false, this.jsWebSocket, "onopen", new Object[0]);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketText(String data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket message data {}", (Object)data);
        }
        Object event = this.javaScript.evaluate("event", "({data:'" + data + "'})");
        this.javaScript.invoke(false, this.jsWebSocket, "onmessage", event);
    }

    public void onWebSocketClose(int closeCode, String reason) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket closed with code {}/{}", (Object)closeCode, (Object)reason);
        }
        Object event = this.javaScript.evaluate("event", "({code:" + closeCode + ",reason:'" + reason + "'})");
        this.javaScript.invoke(false, this.jsWebSocket, "onclose", event);
    }

    public void onWebSocketError(Throwable x) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("WebSocket exception", x);
        }
        this.javaScript.invoke(false, this.jsWebSocket, "onerror", new Object[0]);
    }
}

