/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.cometd.javascript.JavaScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScript
implements Runnable {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(Executors.privilegedThreadFactory());
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<FutureTask<?>> queue = new LinkedBlockingQueue();
    private final Thread thread = new Thread((Runnable)this, "javascript");
    private final Context context = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).build();
    private final Value bindings = this.context.getBindings("js");
    private volatile boolean running;

    public JavaScript() {
        this.bindings.putMember("javaScript", (Object)this);
    }

    public Value bindings() {
        return this.bindings;
    }

    public void init() {
        this.queue.clear();
        this.running = true;
        this.thread.start();
    }

    public void destroy() throws Exception {
        this.running = false;
        for (FutureTask futureTask : this.queue) {
            futureTask.cancel(false);
        }
        this.thread.interrupt();
        this.thread.join();
        this.context.close();
        this.scheduler.shutdown();
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                FutureTask<?> task = this.queue.take();
                task.run();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public <T> T invoke(boolean sync, Object jsThis, Object function, Object ... arguments) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.context.enter();
            try {
                Value self = Value.asValue((Object)jsThis);
                Value funktion = Value.asValue((Object)function);
                if (funktion.canExecute()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Invoking function {}", function);
                    }
                    Value value = funktion.getMember("call").execute(this.coalesce(self, arguments));
                    return value;
                }
                String name = funktion.asString();
                if (self.hasMember(name)) {
                    Value member = self.getMember(name);
                    if (member.canExecute()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Invoking object+function {}", (Object)name);
                        }
                        Value value = member.getMember("call").execute(this.coalesce(self, arguments));
                        return value;
                    }
                    this.logger.info("Member {} not a function in {}", (Object)name, jsThis);
                    Object var8_12 = null;
                    return var8_12;
                }
                this.logger.info("{} not a member in {}", (Object)name, jsThis);
                Object var7_10 = null;
                return var7_10;
            }
            catch (Throwable x) {
                this.logger.info("Exception while trying to invoke " + function, x);
                throw x;
            }
            finally {
                this.context.leave();
            }
        });
        this.submit(task);
        if (!sync) {
            return null;
        }
        return (T)this.result(task);
    }

    private Object[] coalesce(Object item, Object ... rest) {
        int length = rest.length;
        Object[] args = new Object[length + 1];
        args[0] = item;
        if (length > 0) {
            System.arraycopy(rest, 0, args, 1, length);
        }
        return args;
    }

    public <T> T evaluate(URL url) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.context.enter();
            try {
                Value value = this.context.eval(Source.newBuilder((String)"js", (URL)url).build());
                return value;
            }
            catch (Throwable x) {
                throw new JavaScriptException(x);
            }
            finally {
                this.context.leave();
            }
        });
        return (T)this.submitTask(task);
    }

    public <T> T evaluate(String name, String code) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.context.enter();
            try {
                Object t = this.convert(this.context.eval(Source.newBuilder((String)"js", (CharSequence)code, (String)name).build()));
                return t;
            }
            catch (Throwable x) {
                throw new JavaScriptException(x);
            }
            finally {
                this.context.leave();
            }
        });
        return (T)this.submitTask(task);
    }

    private <T> T submitTask(FutureTask<T> task) {
        this.submit(task);
        return this.result(task);
    }

    public <T> T get(String key) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.context.enter();
            try {
                Object t = this.convert(this.bindings.getMember(key));
                return t;
            }
            finally {
                this.context.leave();
            }
        });
        this.submit(task);
        return (T)this.result(task);
    }

    public void put(String key, Object value) {
        this.bindings.putMember(key, value);
    }

    private <T> T convert(Value value) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.isHostObject()) {
            return (T)value.asHostObject();
        }
        if (value.isBoolean()) {
            Boolean result = value.asBoolean();
            return (T)result;
        }
        if (value.isNumber()) {
            Double result = value.asDouble();
            return (T)result;
        }
        if (value.isString()) {
            return (T)value.asString();
        }
        return (T)value.as(Object.class);
    }

    private void submit(FutureTask<?> task) {
        if (Thread.currentThread() == this.thread) {
            task.run();
        } else if (this.running) {
            this.queue.offer(task);
        } else {
            throw new RejectedExecutionException();
        }
    }

    private <T> T result(FutureTask<T> task) {
        try {
            return task.get();
        }
        catch (InterruptedException x) {
            return null;
        }
        catch (ExecutionException x) {
            Throwable xx = x.getCause();
            if (xx instanceof Error) {
                throw (Error)xx;
            }
            throw (RuntimeException)xx;
        }
    }

    public ScheduledFuture<?> schedule(Object jsThis, Object function, long delay) {
        return this.scheduler.schedule(() -> this.invoke(false, jsThis, function, new Object[0]), delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Object jsThis, Object function, long initialDelay, long delay) {
        return this.scheduler.scheduleWithFixedDelay(() -> this.invoke(false, jsThis, function, new Object[0]), initialDelay, delay, TimeUnit.MILLISECONDS);
    }
}

