/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.cometd.javascript.JavaScriptCookieStore;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class XMLHttpRequestClient {
    private final JavaScriptCookieStore cookieStore;
    private HttpClient httpClient;

    public XMLHttpRequestClient(JavaScriptCookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void start() throws Exception {
        this.httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(1));
        this.httpClient.setMaxConnectionsPerDestination(2);
        this.httpClient.setIdleTimeout(300000L);
        this.httpClient.setCookieStore(this.cookieStore.getStore());
        this.httpClient.setExecutor((Executor)((Object)new PrivilegedExecutor()));
        this.httpClient.start();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void stop() throws Exception {
        this.httpClient.stop();
    }

    private class PrivilegedExecutor
    extends QueuedThreadPool {
        private final ThreadFactory factory = Executors.privilegedThreadFactory();

        public PrivilegedExecutor() {
            this.setName("httpclient");
        }

        public Thread newThread(Runnable runnable) {
            return this.factory.newThread(runnable);
        }
    }
}

