/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.javascript;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.cometd.javascript.JavaScript;
import org.cometd.javascript.XMLHttpRequestClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLHttpRequestExchange {
    private final CometDExchange exchange;

    public XMLHttpRequestExchange(Object client, JavaScript javaScript, Object jsThis, String httpMethod, String url, boolean async) {
        this.exchange = new CometDExchange((XMLHttpRequestClient)client, javaScript, jsThis, httpMethod, url, async);
    }

    public void addRequestHeader(String name, String value) {
        this.exchange.getRequest().headers(headers -> headers.put(name, value));
    }

    public String getMethod() {
        return this.exchange.getRequest().getMethod();
    }

    public void setRequestContent(String data) {
        this.exchange.setRequestContent(data);
    }

    public int getReadyState() {
        return this.exchange.getReadyState();
    }

    public String getResponseText() {
        return this.exchange.getResponseText();
    }

    public int getResponseStatus() {
        return this.exchange.getResponseStatus();
    }

    public String getResponseStatusText() {
        return this.exchange.getResponseStatusText();
    }

    public void abort() {
        this.exchange.abort();
    }

    public String getAllResponseHeaders() {
        return this.exchange.getAllResponseHeaders();
    }

    public String getResponseHeader(String name) {
        return this.exchange.getResponseHeader(name);
    }

    public void send() throws Exception {
        this.exchange.send();
        try {
            if (!this.exchange.isAsynchronous()) {
                this.exchange.get(60L, TimeUnit.SECONDS);
            }
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw (Error)cause;
        }
    }

    public static class CometDExchange
    extends FutureResponseListener {
        private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
        private final JavaScript javaScript;
        private final Object jsThis;
        private final boolean async;
        private volatile boolean aborted;
        private volatile ReadyState readyState;
        private volatile String requestText;
        private volatile String responseText;
        private volatile int responseStatus;
        private volatile String responseStatusText;

        public CometDExchange(XMLHttpRequestClient client, JavaScript javaScript, Object jsThis, String httpMethod, String url, boolean async) {
            super(client.getHttpClient().newRequest(url));
            this.getRequest().method(HttpMethod.fromString((String)httpMethod));
            this.javaScript = javaScript;
            this.jsThis = jsThis;
            this.async = async;
            this.aborted = false;
            this.readyState = ReadyState.OPENED;
            this.responseStatusText = null;
            if (async) {
                this.notifyReadyStateChange(false);
            }
        }

        public boolean isAsynchronous() {
            return this.async;
        }

        private void notifyReadyStateChange(boolean sync) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Notifying onreadystatechange ({}) {}", (Object)this.readyState, (Object)this.getRequest().getURI());
            }
            this.notify(sync, "readystatechange");
        }

        private void notifyLoad() {
            this.notify(true, "load");
        }

        private void notifyError() {
            this.notify(true, "error");
        }

        private void notifyAbort() {
            this.notify(false, "abort");
        }

        private void notify(boolean sync, String event) {
            this.javaScript.invoke(sync, this.jsThis, "on" + event, new Object[0]);
        }

        public void send() {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Submitted {}", (Object)this);
            }
            this.getRequest().send((Response.CompleteListener)this);
        }

        public void abort() {
            this.cancel(false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Aborted {}", (Object)this);
            }
            this.aborted = true;
            this.responseText = null;
            this.getRequest().headers(HttpFields.Mutable::clear);
            if (this.readyState == ReadyState.HEADERS_RECEIVED || this.readyState == ReadyState.LOADING) {
                this.readyState = ReadyState.DONE;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(false);
                    this.notifyAbort();
                }
            } else {
                this.readyState = ReadyState.UNSENT;
            }
        }

        public int getReadyState() {
            return this.readyState.ordinal();
        }

        public String getResponseText() {
            return this.responseText;
        }

        public int getResponseStatus() {
            return this.responseStatus;
        }

        public String getResponseStatusText() {
            return this.responseStatusText;
        }

        public void setRequestContent(String content) {
            this.requestText = content;
            this.getRequest().body((Request.Content)new StringRequestContent(content));
        }

        public String getAllResponseHeaders() {
            return this.getRequest().getHeaders().toString();
        }

        public String getResponseHeader(String name) {
            return this.getRequest().getHeaders().get(name);
        }

        public void onBegin(Response response) {
            super.onBegin(response);
            this.responseStatus = response.getStatus();
            this.responseStatusText = response.getReason();
        }

        public void onHeaders(Response response) {
            super.onHeaders(response);
            if (!this.aborted) {
                this.readyState = ReadyState.HEADERS_RECEIVED;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(true);
                }
            }
        }

        public void onContent(Response response, ByteBuffer content) {
            super.onContent(response, content);
            if (!this.aborted && this.readyState != ReadyState.LOADING) {
                this.readyState = ReadyState.LOADING;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(true);
                }
            }
        }

        public void onComplete(Result result) {
            if (result.isSucceeded()) {
                Response response = result.getResponse();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Succeeded ({}) {}", (Object)response.getStatus(), (Object)this);
                }
                if (!this.aborted) {
                    this.responseText = this.getContentAsString();
                    this.readyState = ReadyState.DONE;
                    if (this.isAsynchronous()) {
                        this.notifyReadyStateChange(true);
                        this.notifyLoad();
                    }
                }
            } else {
                Throwable failure = result.getFailure();
                if (!(failure instanceof EOFException) && this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed " + String.valueOf((Object)this), failure);
                }
                this.readyState = ReadyState.DONE;
                if (this.isAsynchronous()) {
                    this.notifyReadyStateChange(true);
                    this.notifyError();
                }
            }
            super.onComplete(result);
        }

        public String toString() {
            if (this.requestText == null) {
                return String.format("%s(%s)", new Object[]{this.getRequest(), this.readyState});
            }
            return String.format("%s(%s)%n%s", new Object[]{this.getRequest(), this.readyState, this.requestText});
        }

        public static enum ReadyState {
            UNSENT,
            OPENED,
            HEADERS_RECEIVED,
            LOADING,
            DONE;

        }
    }
}

