/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi;

import java.io.IOException;
import lombok.NonNull;
import org.dotwebstack.framework.config.ConfigurationException;
import org.dotwebstack.framework.frontend.http.HttpConfiguration;
import org.dotwebstack.framework.frontend.http.HttpModule;
import org.dotwebstack.framework.frontend.openapi.OpenApiRequestMapper;
import org.dotwebstack.framework.frontend.openapi.entity.EntityWriterInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class OpenApiModule
implements HttpModule {
    private OpenApiRequestMapper requestMapper;

    @Autowired
    public OpenApiModule(@NonNull OpenApiRequestMapper requestMapper) {
        if (requestMapper == null) {
            throw new NullPointerException("requestMapper");
        }
        this.requestMapper = requestMapper;
    }

    public void initialize(@NonNull HttpConfiguration httpConfiguration) {
        if (httpConfiguration == null) {
            throw new NullPointerException("httpConfiguration");
        }
        httpConfiguration.register(EntityWriterInterceptor.class);
        try {
            this.requestMapper.map(httpConfiguration);
        }
        catch (IOException exp) {
            throw new ConfigurationException("Failed loading OpenAPI definitions.", (Throwable)exp);
        }
    }
}

