/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.parser.SwaggerParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.dotwebstack.framework.ApplicationProperties;
import org.dotwebstack.framework.EnvironmentAwareResource;
import org.dotwebstack.framework.config.ConfigurationException;
import org.dotwebstack.framework.frontend.http.HttpConfiguration;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ResponseProperty;
import org.dotwebstack.framework.frontend.openapi.handlers.GetRequestHandlerFactory;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.dotwebstack.framework.informationproduct.InformationProductResourceProvider;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Service;

@Service
class OpenApiRequestMapper
implements ResourceLoaderAware,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiRequestMapper.class);
    private final InformationProductResourceProvider informationProductResourceProvider;
    private final SwaggerParser openApiParser;
    private final GetRequestHandlerFactory getRequestHandlerFactory;
    private ApplicationProperties applicationProperties;
    private ResourceLoader resourceLoader;
    private Environment environment;
    private ValueFactory valueFactory = SimpleValueFactory.getInstance();

    @Autowired
    public OpenApiRequestMapper(@NonNull InformationProductResourceProvider informationProductLoader, @NonNull SwaggerParser openApiParser, @NonNull ApplicationProperties applicationProperties, @NonNull GetRequestHandlerFactory getRequestHandlerFactory) {
        if (informationProductLoader == null) {
            throw new NullPointerException("informationProductLoader");
        }
        if (openApiParser == null) {
            throw new NullPointerException("openApiParser");
        }
        if (applicationProperties == null) {
            throw new NullPointerException("applicationProperties");
        }
        if (getRequestHandlerFactory == null) {
            throw new NullPointerException("getRequestHandlerFactory");
        }
        this.informationProductResourceProvider = informationProductLoader;
        this.openApiParser = openApiParser;
        this.applicationProperties = applicationProperties;
        this.getRequestHandlerFactory = getRequestHandlerFactory;
    }

    public void setResourceLoader(@NonNull ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new NullPointerException("resourceLoader");
        }
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(@NonNull Environment environment) {
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        this.environment = environment;
    }

    void map(@NonNull HttpConfiguration httpConfiguration) throws IOException {
        org.springframework.core.io.Resource[] resources;
        if (httpConfiguration == null) {
            throw new NullPointerException("httpConfiguration");
        }
        try {
            resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources(this.applicationProperties.getResourcePath() + "/openapi/**.y*ml");
        }
        catch (FileNotFoundException exp) {
            LOG.warn("No Open API resources found in path:{}/openapi", (Object)this.applicationProperties.getResourcePath());
            return;
        }
        for (org.springframework.core.io.Resource resource : resources) {
            InputStream inputStream = new EnvironmentAwareResource(resource.getInputStream(), this.environment).getInputStream();
            String result = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
            if (StringUtils.isBlank((CharSequence)result)) continue;
            Swagger swagger = this.openApiParser.parse(result);
            this.mapOpenApiDefinition(swagger, httpConfiguration);
        }
    }

    private void mapOpenApiDefinition(Swagger swagger, HttpConfiguration httpConfiguration) {
        String basePath = this.createBasePath(swagger);
        swagger.getPaths().forEach((path, pathItem) -> {
            List produces;
            String absolutePath = basePath.concat((String)path);
            Operation getOperation = pathItem.getGet();
            if (getOperation == null) {
                return;
            }
            if (!getOperation.getVendorExtensions().containsKey(OpenApiSpecificationExtensions.INFORMATION_PRODUCT)) {
                LOG.warn("Path '{}' is not mapped to an information product.", (Object)absolutePath);
                return;
            }
            String okStatusCode = Integer.toString(Response.Status.OK.getStatusCode());
            if (getOperation.getResponses() == null || !getOperation.getResponses().containsKey(okStatusCode)) {
                throw new ConfigurationException(String.format("Resource '%s' does not specify a status %s response.", absolutePath, okStatusCode));
            }
            List list = produces = getOperation.getProduces() != null ? getOperation.getProduces() : swagger.getProduces();
            if (produces == null) {
                throw new ConfigurationException(String.format("Path '%s' should produce at least one media type.", absolutePath));
            }
            Response response = (Response)getOperation.getResponses().get(okStatusCode);
            if (response.getSchema() == null) {
                throw new ConfigurationException(String.format("Resource '%s' does not specify a schema for the status %s response.", absolutePath, okStatusCode));
            }
            ResponseProperty property = new ResponseProperty(response);
            Map<MediaType, Property> schemaMap = produces.stream().collect(Collectors.toMap(MediaType::valueOf, mediaType -> property));
            IRI informationProductIdentifier = this.valueFactory.createIRI((String)getOperation.getVendorExtensions().get(OpenApiSpecificationExtensions.INFORMATION_PRODUCT));
            InformationProduct informationProduct = (InformationProduct)this.informationProductResourceProvider.get(informationProductIdentifier);
            Resource.Builder resourceBuilder = Resource.builder().path(absolutePath);
            ResourceMethod.Builder methodBuilder = resourceBuilder.addMethod("GET").handledBy((Inflector)this.getRequestHandlerFactory.newGetRequestHandler(getOperation, informationProduct, schemaMap, swagger));
            produces.forEach(xva$0 -> methodBuilder.produces(new String[]{xva$0}));
            httpConfiguration.registerResources(new Resource[]{resourceBuilder.build()});
            LOG.debug("Mapped GET operation for request path {}", (Object)absolutePath);
        });
    }

    private String createBasePath(Swagger swagger) {
        String basePath = "/";
        if (swagger.getHost() == null) {
            throw new ConfigurationException(String.format("OpenAPI definition document '%s' must contain a 'host' attribute.", swagger.getInfo().getDescription()));
        }
        basePath = basePath.concat(swagger.getHost());
        if (swagger.getBasePath() != null) {
            basePath = basePath.concat(swagger.getBasePath());
        }
        return basePath;
    }
}

