/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import java.io.IOException;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.AbstractEntity;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityMapper;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntityMapper;
import org.springframework.beans.factory.annotation.Autowired;

public final class EntityWriterInterceptor
implements WriterInterceptor {
    private final TupleEntityMapper tupleEntityMapper;
    private final GraphEntityMapper graphEntityMapper;

    @Autowired
    public EntityWriterInterceptor(@NonNull GraphEntityMapper graphEntityMapper, @NonNull TupleEntityMapper tupleEntityMapper) {
        if (graphEntityMapper == null) {
            throw new NullPointerException("graphEntityMapper");
        }
        if (tupleEntityMapper == null) {
            throw new NullPointerException("tupleEntityMapper");
        }
        this.graphEntityMapper = graphEntityMapper;
        this.tupleEntityMapper = tupleEntityMapper;
    }

    public void aroundWriteTo(@NonNull WriterInterceptorContext context) throws IOException {
        Object mappedEntity;
        AbstractEntity entity;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (context.getEntity() instanceof TupleEntity) {
            entity = (TupleEntity)context.getEntity();
            mappedEntity = this.tupleEntityMapper.map((TupleEntity)entity, context.getMediaType());
            context.setEntity(mappedEntity);
        }
        if (context.getEntity() instanceof GraphEntity) {
            entity = (GraphEntity)context.getEntity();
            mappedEntity = this.graphEntityMapper.map((GraphEntity)entity, context.getMediaType());
            context.setEntity(mappedEntity);
        }
        context.proceed();
    }
}

