/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import com.google.common.collect.ImmutableMap;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.AbstractEntity;
import org.dotwebstack.framework.frontend.openapi.entity.Entity;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityContext;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutorRuntimeException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;

public final class GraphEntity
extends AbstractEntity {
    private final GraphEntityContext graphEntityContext;

    GraphEntity(@NonNull Map<MediaType, Property> schemaMap, @NonNull GraphEntityContext graphEntityContext) {
        super(schemaMap);
        if (schemaMap == null) {
            throw new NullPointerException("schemaMap");
        }
        if (graphEntityContext == null) {
            throw new NullPointerException("graphEntityContext");
        }
        this.graphEntityContext = graphEntityContext;
    }

    GraphEntityContext getEntityContext() {
        return this.graphEntityContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, Model> swaggerDefinitions;
        private ImmutableMap<String, String> ldpathNamespaces;
        private org.eclipse.rdf4j.model.Model model;
        private Map<MediaType, Property> schemaMap;

        public Builder withSchemaMap(@NonNull Map<MediaType, Property> schemaMap) {
            if (schemaMap == null) {
                throw new NullPointerException("schemaMap");
            }
            this.schemaMap = schemaMap;
            return this;
        }

        public Builder withQueryResult(@NonNull QueryResult queryResult) {
            if (queryResult == null) {
                throw new NullPointerException("queryResult");
            }
            this.model = QueryResults.asModel((CloseableIteration)queryResult);
            return this;
        }

        public Builder withApiDefinitions(@NonNull Swagger definitions) {
            if (definitions == null) {
                throw new NullPointerException("definitions");
            }
            this.swaggerDefinitions = Builder.extractSwaggerDefinitions(definitions);
            return this;
        }

        public Builder withLdPathNamespaces(@NonNull Swagger definitions) {
            if (definitions == null) {
                throw new NullPointerException("definitions");
            }
            this.ldpathNamespaces = this.extractLdpathNamespaces(definitions);
            return this;
        }

        private static Map<String, Model> extractSwaggerDefinitions(Swagger swagger) {
            if (swagger.getDefinitions() != null) {
                return ImmutableMap.copyOf((Map)swagger.getDefinitions());
            }
            return ImmutableMap.of();
        }

        private ImmutableMap<String, String> extractLdpathNamespaces(Swagger swagger) {
            ImmutableMap vendorExtensions;
            Map extensions = swagger.getVendorExtensions();
            ImmutableMap immutableMap = vendorExtensions = extensions == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)extensions);
            if (vendorExtensions.containsKey((Object)OpenApiSpecificationExtensions.LDPATH_NAMESPACES)) {
                Object ldPathNamespaces = vendorExtensions.get((Object)OpenApiSpecificationExtensions.LDPATH_NAMESPACES);
                try {
                    return ImmutableMap.copyOf((Map)((Map)ldPathNamespaces));
                }
                catch (ClassCastException cce) {
                    throw new LdPathExecutorRuntimeException(String.format("Vendor extension '%s' should contain a map of namespaces (eg. { \"rdfs\": \"http://www.w3.org/2000/01/rdf-schema#\", \"rdf\": \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"})", OpenApiSpecificationExtensions.LDPATH_NAMESPACES), cce);
                }
            }
            return ImmutableMap.of();
        }

        public Entity build() {
            return new GraphEntity(this.schemaMap, new GraphEntityContext(this.ldpathNamespaces, this.swaggerDefinitions, this.model));
        }
    }
}

