/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import io.swagger.models.properties.Property;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.AbstractEntity;
import org.eclipse.rdf4j.query.TupleQueryResult;

public final class TupleEntity
extends AbstractEntity {
    private final TupleQueryResult queryResult;

    TupleEntity(@NonNull Map<MediaType, Property> schemaProperty, @NonNull TupleQueryResult queryResult) {
        super(schemaProperty);
        if (schemaProperty == null) {
            throw new NullPointerException("schemaProperty");
        }
        if (queryResult == null) {
            throw new NullPointerException("queryResult");
        }
        this.queryResult = queryResult;
    }

    public TupleQueryResult getResult() {
        return this.queryResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<MediaType, Property> schemaMap;
        private TupleQueryResult tupleQueryResult;

        public Builder withQueryResult(@NonNull TupleQueryResult queryResult) {
            if (queryResult == null) {
                throw new NullPointerException("queryResult");
            }
            this.tupleQueryResult = queryResult;
            return this;
        }

        public Builder withSchemaMap(@NonNull Map<MediaType, Property> schemaMap) {
            if (schemaMap == null) {
                throw new NullPointerException("schemaMap");
            }
            this.schemaMap = schemaMap;
            return this;
        }

        public TupleEntity build() {
            return new TupleEntity(this.schemaMap, this.tupleQueryResult);
        }
    }
}

