/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.EntityMapper;
import org.dotwebstack.framework.frontend.openapi.entity.EntityMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ResponseProperty;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class TupleEntityMapper
implements EntityMapper<TupleEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(TupleEntityMapper.class);
    private final SchemaMapperAdapter schemaMapperAdapter;

    @Autowired
    public TupleEntityMapper(@NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        this.schemaMapperAdapter = schemaMapperAdapter;
    }

    @Override
    public Object map(@NonNull TupleEntity entity, @NonNull MediaType mediaType) {
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (mediaType == null) {
            throw new NullPointerException("mediaType");
        }
        Property schema = (Property)entity.getSchemaMap().get(mediaType);
        ValueContext valueContext = ValueContext.builder().build();
        if (schema == null) {
            throw new EntityMapperRuntimeException(String.format("No schema found for media type '%s'.", mediaType.toString()));
        }
        if (schema instanceof ResponseProperty) {
            schema = ((ResponseProperty)schema).getSchema();
        }
        if (schema instanceof ObjectProperty) {
            return this.mapObject(entity, (ObjectProperty)schema, valueContext);
        }
        if (schema instanceof ArrayProperty) {
            return this.mapCollection(entity, (ArrayProperty)schema, valueContext);
        }
        return ImmutableMap.of();
    }

    private Object mapObject(TupleEntity entity, ObjectProperty schema, ValueContext valueContext) {
        TupleQueryResult result = entity.getResult();
        if (result.hasNext()) {
            BindingSet bindingSet = (BindingSet)result.next();
            if (result.hasNext()) {
                LOG.warn("TupleQueryResult yielded several bindingsets. Only parsing the first.");
            }
            return this.mapBindingSet(bindingSet, schema.getProperties(), valueContext);
        }
        throw new EntityMapperRuntimeException("TupleQueryResult did not yield any values.");
    }

    private Object mapCollection(TupleEntity entity, ArrayProperty schema, ValueContext valueContext) {
        Property itemSchema = schema.getItems();
        if (itemSchema == null) {
            throw new EntityMapperRuntimeException("Array schemas must have an 'items' property.");
        }
        if (!(itemSchema instanceof ObjectProperty)) {
            throw new EntityMapperRuntimeException("Only array items of type 'object' are supported for now.");
        }
        TupleQueryResult result = entity.getResult();
        ImmutableList.Builder collectionBuilder = new ImmutableList.Builder();
        Map itemProperties = ((ObjectProperty)itemSchema).getProperties();
        while (result.hasNext()) {
            collectionBuilder.add(this.mapBindingSet((BindingSet)result.next(), itemProperties, valueContext));
        }
        return collectionBuilder.build();
    }

    private ImmutableMap<String, Object> mapBindingSet(BindingSet bindingSet, Map<String, Property> itemProperties, ValueContext valueContext) {
        ImmutableMap.Builder itemBuilder = new ImmutableMap.Builder();
        itemProperties.forEach((name, property) -> {
            if (property.getRequired() && !bindingSet.hasBinding(name)) {
                throw new EntityMapperRuntimeException(String.format("Property '%s' is required.", name));
            }
            if (!bindingSet.hasBinding(name)) {
                itemBuilder.put(name, (Object)Optional.absent());
                return;
            }
            ValueContext newValueContext = valueContext.toBuilder().value(bindingSet.getValue(name)).build();
            itemBuilder.put(name, this.schemaMapperAdapter.mapTupleValue(property, newValueContext));
        });
        return itemBuilder.build();
    }
}

