/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.backend;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.NonNull;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.dotwebstack.framework.frontend.openapi.entity.backend.Rdf4jValueBackend;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRdf4jBackend
extends Rdf4jValueBackend
implements RDFBackend<Value> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRdf4jBackend.class);

    protected IRI createUriInternal(@NonNull ValueFactory valueFactory, @NonNull String uri) {
        if (valueFactory == null) {
            throw new NullPointerException("valueFactory");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        return valueFactory.createIRI(uri);
    }

    protected Literal createLiteralInternal(@NonNull ValueFactory valueFactory, @NonNull String content) {
        if (valueFactory == null) {
            throw new NullPointerException("valueFactory");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        LOG.debug("creating literal with content \"{}\"", (Object)content);
        return valueFactory.createLiteral(content);
    }

    protected Literal createLiteralInternal(@NonNull ValueFactory valueFactory, @NonNull String content, Locale language, URI type) {
        if (valueFactory == null) {
            throw new NullPointerException("valueFactory");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        LOG.debug("creating literal with content \"{}\", language {}, datatype {}", new Object[]{content, language, type});
        if (language == null && type == null) {
            return valueFactory.createLiteral(content);
        }
        if (type == null) {
            return valueFactory.createLiteral(content, language.getLanguage());
        }
        return valueFactory.createLiteral(content, valueFactory.createIRI(type.toString()));
    }

    protected Collection<Value> listObjectsInternal(@NonNull RepositoryConnection connection, Resource subject, IRI property, boolean includeInferred, Resource ... contexts) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        ValueFactory valueFactory = connection.getValueFactory();
        HashSet<Value> result = new HashSet<Value>();
        try (RepositoryResult queryResult = connection.getStatements(this.merge(subject, valueFactory), this.merge(property, valueFactory), null, includeInferred, contexts);){
            while (queryResult.hasNext()) {
                result.add(((Statement)queryResult.next()).getObject());
            }
        }
        return ImmutableSet.copyOf(result);
    }

    protected Collection<Value> listSubjectsInternal(@NonNull RepositoryConnection connection, IRI property, Value object, boolean includeInferred, Resource ... contexts) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        ValueFactory valueFactory = connection.getValueFactory();
        HashSet<Resource> result = new HashSet<Resource>();
        try (RepositoryResult queryResult = connection.getStatements(null, this.merge(property, valueFactory), this.merge(object, valueFactory), includeInferred, contexts);){
            while (queryResult.hasNext()) {
                result.add(((Statement)queryResult.next()).getSubject());
            }
        }
        return ImmutableSet.copyOf(result);
    }

    private <T extends Value> T merge(T value, @NonNull ValueFactory vf) {
        if (vf == null) {
            throw new NullPointerException("vf");
        }
        if (value instanceof IRI) {
            return (T)vf.createIRI(value.stringValue());
        }
        if (value instanceof BNode) {
            return (T)vf.createBNode(((BNode)value).getID());
        }
        return value;
    }

    @Override
    public abstract Literal createLiteral(String var1);

    @Override
    public abstract Literal createLiteral(String var1, Locale var2, URI var3);

    @Override
    public abstract IRI createURI(String var1);

    public boolean supportsThreading() {
        return false;
    }

    public ThreadPoolExecutor getThreadPool() {
        return null;
    }
}

