/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import io.swagger.models.properties.Property;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityContext;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

abstract class AbstractSubjectFilterSchemaMapper<S extends Property, T>
extends AbstractSchemaMapper<S, T> {
    AbstractSubjectFilterSchemaMapper() {
    }

    protected boolean hasSubjectFilterVendorExtension(@NonNull Property property) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        return AbstractSubjectFilterSchemaMapper.hasVendorExtension(property, OpenApiSpecificationExtensions.SUBJECT_FILTER);
    }

    protected final Set<Resource> filterSubjects(@NonNull Property property, @NonNull GraphEntityContext graphEntityContext) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        if (graphEntityContext == null) {
            throw new NullPointerException("graphEntityContext");
        }
        if (!this.hasSubjectFilterVendorExtension(property)) {
            throw new IllegalStateException(String.format("Vendor extension '%s' not defined, please call hasSubjectFilterVendorExtension() before calling this method", OpenApiSpecificationExtensions.SUBJECT_FILTER));
        }
        Map subjectFilter = (Map)property.getVendorExtensions().get(OpenApiSpecificationExtensions.SUBJECT_FILTER);
        String predicate = (String)subjectFilter.get("predicate");
        String object = (String)subjectFilter.get("object");
        if (predicate == null || object == null) {
            throw new SchemaMapperRuntimeException("Subject filter cannot work without missing predicate or object.");
        }
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI predicateIri = vf.createIRI(predicate);
        IRI objectIri = vf.createIRI(object);
        Model filteredModel = graphEntityContext.getModel().filter(null, predicateIri, (Value)objectIri, new Resource[0]);
        return filteredModel.subjects();
    }
}

