/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.Property;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityContext;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperUtils;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.springframework.stereotype.Service;

@Service
class BooleanSchemaMapper
implements SchemaMapper<BooleanProperty, Boolean> {
    BooleanSchemaMapper() {
    }

    @Override
    public Boolean mapTupleValue(@NonNull BooleanProperty schema, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        return SchemaMapperUtils.castLiteralValue(valueContext.getValue()).booleanValue();
    }

    @Override
    public Boolean mapGraphValue(@NonNull BooleanProperty schema, @NonNull GraphEntityContext graphEntityContext, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (graphEntityContext == null) {
            throw new NullPointerException("graphEntityContext");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        return SchemaMapperUtils.castLiteralValue(valueContext.getValue()).booleanValue();
    }

    @Override
    public boolean supports(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema instanceof BooleanProperty;
    }
}

