/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.collect.ImmutableSet;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.Property;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityContext;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutor;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperUtils;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.springframework.stereotype.Service;

@Service
class DateSchemaMapper
extends AbstractSchemaMapper<DateProperty, LocalDate> {
    private static final Set<IRI> SUPPORTED_TYPES = ImmutableSet.of((Object)XMLSchema.DATE);

    DateSchemaMapper() {
    }

    @Override
    public LocalDate mapTupleValue(@NonNull DateProperty schema, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        return this.convertToDate(SchemaMapperUtils.castLiteralValue(valueContext.getValue()).calendarValue());
    }

    @Override
    public LocalDate mapGraphValue(@NonNull DateProperty property, @NonNull GraphEntityContext context, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        String ldPathQuery = (String)property.getVendorExtensions().get(OpenApiSpecificationExtensions.LDPATH);
        if (ldPathQuery == null && this.isSupportedLiteral(valueContext.getValue())) {
            return this.convertToDate(((Literal)valueContext.getValue()).calendarValue());
        }
        if (ldPathQuery == null) {
            throw new SchemaMapperRuntimeException(String.format("Property '%s' must have a '%s' attribute.", property.getName(), OpenApiSpecificationExtensions.LDPATH));
        }
        LdPathExecutor ldPathExecutor = context.getLdPathExecutor();
        Collection<Value> queryResult = ldPathExecutor.ldPathQuery(valueContext.getValue(), ldPathQuery);
        if (!property.getRequired() && queryResult.isEmpty()) {
            return null;
        }
        Value dateValue = DateSchemaMapper.getSingleStatement(queryResult, ldPathQuery);
        if (!this.isSupportedLiteral(dateValue)) {
            throw new SchemaMapperRuntimeException(String.format("LDPath query '%s' yielded a value which is not a literal of supported type: <%s>.", ldPathQuery, this.dataTypesAsString()));
        }
        return this.convertToDate(((Literal)dateValue).calendarValue());
    }

    private LocalDate convertToDate(XMLGregorianCalendar dateValue) {
        return dateValue.toGregorianCalendar().toZonedDateTime().toLocalDate();
    }

    @Override
    public boolean supports(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema instanceof DateProperty;
    }

    @Override
    protected Set<IRI> getSupportedDataTypes() {
        return SUPPORTED_TYPES;
    }
}

