/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.collect.ImmutableSet;
import io.swagger.models.properties.Property;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityContext;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSubjectFilterSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ResponseProperty;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.springframework.stereotype.Service;

@Service
class ResponseSchemaMapper
extends AbstractSubjectFilterSchemaMapper<ResponseProperty, Object> {
    ResponseSchemaMapper() {
    }

    @Override
    public Object mapTupleValue(@NonNull ResponseProperty schema, @NonNull ValueContext value) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object mapGraphValue(@NonNull ResponseProperty property, @NonNull GraphEntityContext graphEntityContext, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        if (graphEntityContext == null) {
            throw new NullPointerException("graphEntityContext");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        ValueContext.ValueContextBuilder builder = valueContext.toBuilder();
        if (this.hasSubjectFilterVendorExtension(property)) {
            Set<Resource> subjects = this.filterSubjects(property, graphEntityContext);
            if (subjects.isEmpty()) {
                if (property.getRequired()) {
                    throw new SchemaMapperRuntimeException("Subject filter for a required object property yielded no result.");
                }
                return null;
            }
            if (subjects.size() > 1) {
                throw new SchemaMapperRuntimeException("More entrypoint subjects found. Only one is required.");
            }
            builder.value((Value)subjects.iterator().next());
        }
        return schemaMapperAdapter.mapGraphValue(property.getSchema(), graphEntityContext, builder.build(), schemaMapperAdapter);
    }

    @Override
    public boolean supports(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema instanceof ResponseProperty;
    }

    @Override
    protected Set<IRI> getSupportedDataTypes() {
        return ImmutableSet.of();
    }
}

