/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.collect.ImmutableList;
import io.swagger.models.properties.Property;
import java.util.List;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityContext;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchemaMapperAdapter {
    private ImmutableList<SchemaMapper<? extends Property, ?>> schemaMappers;

    @Autowired
    public SchemaMapperAdapter(@NonNull List<SchemaMapper<? extends Property, ?>> schemaMappers) {
        if (schemaMappers == null) {
            throw new NullPointerException("schemaMappers");
        }
        this.schemaMappers = ImmutableList.copyOf(schemaMappers);
    }

    public <S extends Property> Object mapTupleValue(@NonNull S schema, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        SchemaMapper schemaMapper = this.schemaMappers.stream().filter(candidateMapper -> candidateMapper.supports(schema)).findFirst().orElseThrow(() -> new SchemaMapperRuntimeException(String.format("No schema mapper available for '%s'.", schema.getClass().getName())));
        return schemaMapper.mapTupleValue(schema, valueContext);
    }

    public <S extends Property> Object mapGraphValue(@NonNull S schema, GraphEntityContext graphEntityContext, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        SchemaMapper schemaMapper = this.schemaMappers.stream().filter(candidateMapper -> candidateMapper.supports(schema)).findFirst().orElseThrow(() -> new SchemaMapperRuntimeException(String.format("No schema mapper available for '%s'.", schema.getClass().getName())));
        return schemaMapper.mapGraphValue(schema, graphEntityContext, valueContext, schemaMapperAdapter);
    }
}

