/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.collect.ImmutableSet;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityContext;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutor;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class StringSchemaMapper
extends AbstractSchemaMapper<StringProperty, String> {
    private static final Logger LOG = LoggerFactory.getLogger(StringSchemaMapper.class);
    private static final Set<IRI> SUPPORTED_TYPES = ImmutableSet.of((Object)XMLSchema.STRING, (Object)RDF.LANGSTRING);

    StringSchemaMapper() {
    }

    @Override
    public String mapTupleValue(@NonNull StringProperty schema, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        return valueContext.getValue().stringValue();
    }

    @Override
    public String mapGraphValue(@NonNull StringProperty property, @NonNull GraphEntityContext graphEntityContext, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        if (graphEntityContext == null) {
            throw new NullPointerException("graphEntityContext");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        this.validateVendorExtensions(property);
        Map vendorExtensions = property.getVendorExtensions();
        if (vendorExtensions.containsKey(OpenApiSpecificationExtensions.LDPATH)) {
            LdPathExecutor ldPathExecutor = graphEntityContext.getLdPathExecutor();
            return this.handleLdPathVendorExtension(property, valueContext.getValue(), ldPathExecutor);
        }
        if (vendorExtensions.containsKey("x-constant-value")) {
            return this.handleConstantValueVendorExtension(property);
        }
        if (valueContext.getValue() != null && this.isSupportedLiteral(valueContext.getValue())) {
            return valueContext.getValue().stringValue();
        }
        if (property.getRequired()) {
            throw new SchemaMapperRuntimeException("No result for required property.");
        }
        return null;
    }

    private void validateVendorExtensions(StringProperty property) {
        ImmutableSet supportedVendorExtensions = ImmutableSet.of((Object)OpenApiSpecificationExtensions.LDPATH, (Object)"x-relative-link", (Object)"x-constant-value");
        long nrOfSupportedVendorExtentionsPresent = property.getVendorExtensions().keySet().stream().filter(arg_0 -> ((ImmutableSet)supportedVendorExtensions).contains(arg_0)).count();
        if (nrOfSupportedVendorExtentionsPresent > 1L) {
            throw new SchemaMapperRuntimeException(String.format("A string object must have either no, a '%s', '%s' or '%s' property. A string object cannot have a combination of these.", OpenApiSpecificationExtensions.LDPATH, "x-relative-link", "x-constant-value"));
        }
    }

    private String handleConstantValueVendorExtension(StringProperty property) {
        Object value = property.getVendorExtensions().get("x-constant-value");
        if (value != null) {
            if (this.isSupportedLiteral(value)) {
                return ((Value)value).stringValue();
            }
            return value.toString();
        }
        if (property.getRequired()) {
            throw new SchemaMapperRuntimeException(String.format("String property has '%s' vendor extension that is null, but the property is required.", "x-constant-value"));
        }
        return null;
    }

    private String handleLdPathVendorExtension(StringProperty property, Value context, LdPathExecutor ldPathExecutor) {
        String ldPathQuery = (String)property.getVendorExtensions().get(OpenApiSpecificationExtensions.LDPATH);
        if (ldPathQuery == null) {
            if (property.getRequired()) {
                throw new SchemaMapperRuntimeException(String.format("String property has '%s' vendor extension that is null, but the property is required.", OpenApiSpecificationExtensions.LDPATH));
            }
            return null;
        }
        Collection<Value> queryResult = ldPathExecutor.ldPathQuery(context, ldPathQuery);
        if (!property.getRequired() && queryResult.isEmpty()) {
            return null;
        }
        LOG.debug("Context: {}", (Object)context);
        return StringSchemaMapper.getSingleStatement(queryResult, ldPathQuery).stringValue();
    }

    @Override
    public boolean supports(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema instanceof StringProperty;
    }

    @Override
    protected Set<IRI> getSupportedDataTypes() {
        return SUPPORTED_TYPES;
    }
}

